/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.mana;

import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.mana.CachedInventoryManaPool;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class PlayerManaPool
extends CachedInventoryManaPool {
    private final List<SlotReference> cached;

    public PlayerManaPool(class_3222 player) {
        super((class_1263)player.method_31548());
        AccessoriesCapability playerAccessories = player.accessoriesCapability();
        this.cached = playerAccessories != null ? playerAccessories.getEquipped(itemStack -> itemStack.method_57826(ModComponents.MANA)).stream().map(SlotEntryReference::reference).toList() : List.of();
    }

    @Override
    public float get(class_1937 world) {
        float result = 0.0f;
        for (SlotReference slotReference : this.cached) {
            ManaComponent component = (ManaComponent)slotReference.getStack().method_57824(ModComponents.MANA);
            if (component == null) continue;
            result += component.pool().get(world);
        }
        return result + super.get(world);
    }

    @Override
    public float getMax(class_1937 world) {
        float result = 0.0f;
        for (SlotReference slotReference : this.cached) {
            ManaComponent component = (ManaComponent)slotReference.getStack().method_57824(ModComponents.MANA);
            if (component == null) continue;
            result += component.pool().getMax(world);
        }
        return result + super.getMax(world);
    }

    @Override
    public float use(float amount, class_1937 world) {
        for (SlotReference slotReference : this.cached) {
            ManaComponent component;
            class_1799 stack = slotReference.getStack();
            if (stack == null || (component = (ManaComponent)stack.method_57824(ModComponents.MANA)) == null) continue;
            MutableManaPool pool = component.pool().makeClone(world);
            amount = pool.use(amount, world);
            stack.method_57379(ModComponents.MANA, (Object)component.with(pool));
            if (!(amount <= 0.0f)) continue;
            return 0.0f;
        }
        return super.use(amount, world);
    }

    @Override
    public float refill(float amount, class_1937 world) {
        for (SlotReference slotReference : this.cached) {
            ManaComponent component;
            class_1799 stack = slotReference.getStack();
            if (stack == null || (component = (ManaComponent)stack.method_57824(ModComponents.MANA)) == null) continue;
            MutableManaPool pool = component.pool().makeClone(world);
            amount = pool.refill(amount, world);
            stack.method_57379(ModComponents.MANA, (Object)component.with(pool));
            if (!(amount <= 0.0f)) continue;
            return 0.0f;
        }
        return super.refill(amount, world);
    }
}

