/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.block;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.block.ModBlocks;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlockTooHardBlunder;
import dev.enjarai.trickster.spell.blunder.BlockUnoccupiedBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BreakBlockTrick
extends Trick<BreakBlockTrick> {
    public BreakBlockTrick() {
        super(Pattern.of(1, 5, 8, 6, 4, 1, 0, 3, 6), Signature.of(FragmentType.VECTOR, BreakBlockTrick::run, FragmentType.VECTOR));
    }

    public VectorFragment run(SpellContext ctx, VectorFragment pos) throws BlunderException {
        class_2338 blockPos = pos.toBlockPos();
        class_3218 world = ctx.source().getWorld();
        this.expectCanBuild(ctx, blockPos);
        class_2680 state = world.method_8320(blockPos);
        if (state.method_26215()) {
            throw new BlockUnoccupiedBlunder(this, pos);
        }
        float hardness = state.method_26204().method_36555();
        if (state.method_26164(ModBlocks.CANNOT_BREAK) || !(hardness >= 0.0f) || !(hardness < Trickster.CONFIG.maxBlockBreakingHardness())) {
            throw new BlockTooHardBlunder(this);
        }
        ctx.useMana(this, Math.max(hardness, 8.0f));
        ctx.source().getCaster().ifPresentOrElse(c -> world.method_8651(blockPos, true, c), () -> world.method_22352(blockPos, true));
        return pos;
    }
}

