/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.block;

import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.CannotPlaceBlockBlunder;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.MissingItemBlunder;
import dev.enjarai.trickster.spell.fragment.BlockTypeFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import org.joml.Vector3d;

public class PlaceBlockTrick
extends Trick<PlaceBlockTrick> {
    public PlaceBlockTrick() {
        super(Pattern.of(0, 2, 8, 6, 0), Signature.of(FragmentType.VECTOR, FragmentType.SLOT, FragmentType.VECTOR.optionalOfArg(), FragmentType.VECTOR.optionalOfArg(), PlaceBlockTrick::placeSlot, FragmentType.VECTOR));
        this.overload(Signature.of(FragmentType.VECTOR, FragmentType.BLOCK_TYPE, FragmentType.VECTOR.optionalOfArg(), FragmentType.VECTOR.optionalOfArg(), PlaceBlockTrick::placeType, FragmentType.VECTOR));
    }

    public VectorFragment placeSlot(SpellContext ctx, VectorFragment pos, SlotFragment slot, Optional<VectorFragment> facing, Optional<VectorFragment> side) throws BlunderException {
        this.expectCanBuild(ctx, pos.toBlockPos());
        class_1799 stack = ctx.getStack(this, Optional.of(slot), item -> item.method_7909() instanceof class_1747).orElseThrow(() -> new MissingItemBlunder(this));
        return this.place(ctx, pos, stack, facing, side);
    }

    public VectorFragment placeType(SpellContext ctx, VectorFragment pos, BlockTypeFragment type, Optional<VectorFragment> facing, Optional<VectorFragment> side) throws BlunderException {
        this.expectCanBuild(ctx, pos.toBlockPos());
        class_1799 stack = ctx.getStack(this, Optional.empty(), item -> {
            class_1747 blockItem;
            class_1792 patt0$temp = item.method_7909();
            return patt0$temp instanceof class_1747 && (blockItem = (class_1747)patt0$temp).method_7711() == type.block();
        }).orElseThrow(() -> new MissingItemBlunder(this));
        return this.place(ctx, pos, stack, facing, side);
    }

    public VectorFragment place(SpellContext ctx, VectorFragment pos, class_1799 stack, Optional<VectorFragment> facingOptional, Optional<VectorFragment> sideOptional) throws BlunderException {
        class_3218 world = ctx.source().getWorld();
        class_2338 blockPos = pos.toBlockPos();
        class_2350 facing = facingOptional.map(VectorFragment::toDirection).orElse(class_2350.field_11033);
        class_2350 side = sideOptional.map(VectorFragment::toDirection).orElse(class_2350.field_11036);
        try {
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof class_1747)) {
                throw new ItemInvalidBlunder(this);
            }
            class_1747 blockItem = (class_1747)class_17922;
            class_2968 placementContext = new class_2968((class_1937)ctx.source().getWorld(), blockPos, facing, stack, side);
            double distance = ctx.source().getPos().distance(pos.vector());
            float mana = Math.max((float)distance, 8.0f);
            ctx.checkMana(this, mana);
            if (!blockItem.method_7712((class_1750)placementContext).method_23665()) {
                throw new CannotPlaceBlockBlunder(this, blockItem.method_7711(), pos);
            }
            ctx.useMana(this, mana);
            return pos;
        }
        catch (BlunderException blunder) {
            Vector3d thisPos = ctx.source().getPos();
            world.method_8649((class_1297)new class_1542((class_1937)world, thisPos.x, thisPos.y, thisPos.z, stack));
            throw blunder;
        }
    }
}

