/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.entity;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.item.component.EntityStorageComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.EntityInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.joml.Vector3dc;

public class ReleaseEntityTrick
extends Trick<ReleaseEntityTrick> {
    public ReleaseEntityTrick() {
        super(Pattern.of(4, 3, 6, 7, 4, 8, 2), Signature.of(FragmentType.VECTOR, ReleaseEntityTrick::release, FragmentType.ENTITY.optionalOfRet()));
    }

    public Optional<EntityFragment> release(SpellContext ctx, VectorFragment vector) throws BlunderException {
        Vector3dc pos = vector.vector();
        class_3222 player = ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(this));
        class_1799 offhand = player.method_6079();
        EntityStorageComponent entityStorage = (EntityStorageComponent)offhand.method_57824(ModComponents.ENTITY_STORAGE);
        if (entityStorage == null) {
            return Optional.empty();
        }
        if (entityStorage.nbt().isPresent()) {
            double dist = player.method_19538().method_1022(new class_243(pos.x(), pos.y(), pos.z()));
            ctx.useMana(this, (float)(2000.0 + Math.pow(dist, dist / 5.0)));
            offhand.method_57379(ModComponents.ENTITY_STORAGE, (Object)new EntityStorageComponent(Optional.empty()));
            Optional entity = class_1299.method_5892((class_2487)entityStorage.nbt().get(), (class_1937)ctx.source().getWorld());
            if (entity.isPresent()) {
                ((class_1297)entity.get()).method_23327(pos.x(), pos.y(), pos.z());
                if (!ctx.source().getWorld().method_8649((class_1297)entity.get())) {
                    throw new EntityInvalidBlunder(this);
                }
                return Optional.of(EntityFragment.from((class_1297)entity.get()));
            }
            Trickster.LOGGER.warn("Failed to read entity from offhand due to invalid NBT, entity storage component has been cleared");
            return Optional.empty();
        }
        return Optional.empty();
    }
}

