/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.inventory;

import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.NumberTooSmallBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.joml.Vector3dc;

public class DropStackFromSlotTrick
extends Trick<DropStackFromSlotTrick> {
    public DropStackFromSlotTrick() {
        super(Pattern.of(1, 4, 7, 3, 4, 5, 7), Signature.of(FragmentType.SLOT, FragmentType.VECTOR, FragmentType.NUMBER.optionalOfArg(), DropStackFromSlotTrick::run, FragmentType.ENTITY));
    }

    public EntityFragment run(SpellContext ctx, SlotFragment slot, VectorFragment pos, Optional<NumberFragment> optionalAmount) throws BlunderException {
        Vector3dc vector = pos.vector();
        double amount = optionalAmount.orElse(new NumberFragment(1.0)).number();
        if (amount < 1.0) {
            throw new NumberTooSmallBlunder(this, 1);
        }
        class_1799 stack = slot.move(this, ctx, (int)Math.round(amount), vector);
        class_3218 world = ctx.source().getWorld();
        class_1542 entity = new class_1542((class_1937)world, vector.x(), vector.y(), vector.z(), stack);
        entity.method_6982(10);
        world.method_8649((class_1297)entity);
        return new EntityFragment(entity.method_5667(), entity.method_5477());
    }
}

