/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.inventory;

import com.mojang.datafixers.util.Either;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;

public class GetInventorySizeTrick
extends Trick<GetInventorySizeTrick> {
    public GetInventorySizeTrick() {
        super(Pattern.of(7, 6, 3, 4, 5, 8, 7, 3, 0, 2, 5, 7), Signature.of(GetInventorySizeTrick::fromCaster, FragmentType.NUMBER));
        this.overload(Signature.of(FragmentType.VECTOR, GetInventorySizeTrick::fromVector, FragmentType.NUMBER));
        this.overload(Signature.of(FragmentType.ENTITY, GetInventorySizeTrick::fromEntity, FragmentType.NUMBER));
    }

    public NumberFragment fromCaster(SpellContext ctx) throws BlunderException {
        return SlotFragment.getInventoryLength(this, ctx, Optional.empty());
    }

    public NumberFragment fromVector(SpellContext ctx, VectorFragment pos) throws BlunderException {
        return SlotFragment.getInventoryLength(this, ctx, Optional.of(Either.left((Object)pos.toBlockPos())));
    }

    public NumberFragment fromEntity(SpellContext ctx, EntityFragment entity) throws BlunderException {
        return SlotFragment.getInventoryLength(this, ctx, Optional.of(Either.right((Object)entity.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder(this)).method_5667())));
    }
}

