/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.mana;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.NumberIsInfiniteBlunder;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.List;
import net.minecraft.class_1799;

public abstract class AbstractConduitTrick
extends Trick<AbstractConduitTrick> {
    public AbstractConduitTrick(Pattern pattern) {
        super(pattern, Signature.of(FragmentType.NUMBER, FragmentType.SLOT.variadicOfArg().require().unpack(), AbstractConduitTrick::run, FragmentType.NUMBER));
    }

    public NumberFragment run(SpellContext ctx, NumberFragment n, List<SlotFragment> slots) throws BlunderException {
        if (Double.isInfinite(n.number())) {
            throw new NumberIsInfiniteBlunder(this);
        }
        double limit = n.number() / (double)slots.size();
        float result = 0.0f;
        for (SlotFragment slot : slots) {
            double distance = ctx.source().getPos().distance(slot.getSourceOrCasterPos(this, ctx));
            float r = Trickster.CONFIG.manaTransferEfficiency();
            double tax = Math.max(0.0, 1.0 - (double)r / (distance + (double)r - 16.0));
            result += this.affect(ctx, slot.reference(this, ctx), (float)limit, tax);
        }
        return new NumberFragment(result);
    }

    protected abstract float affect(SpellContext var1, class_1799 var2, float var3, double var4);
}

