/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.raycast;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.BooleanFragment;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.RetType;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;

public abstract class AbstractRaycastTrick<T extends Fragment>
extends Trick<AbstractRaycastTrick<T>> {
    public AbstractRaycastTrick(Pattern pattern, RetType<T> retType) {
        super(pattern, Signature.of(FragmentType.VECTOR, FragmentType.VECTOR, FragmentType.BOOLEAN.optionalOfArg(), AbstractRaycastTrick::fromVectors, retType.optionalOfRet()));
        this.overload(Signature.of(FragmentType.ENTITY, FragmentType.BOOLEAN.optionalOfArg(), AbstractRaycastTrick::fromEntity, retType.optionalOfRet()));
    }

    public Optional<T> fromVectors(SpellContext ctx, VectorFragment vec1, VectorFragment vec2, Optional<BooleanFragment> bool) throws BlunderException {
        class_243 position = new class_243(vec1.x(), vec1.y(), vec1.z());
        class_243 direction = new class_243(vec2.x(), vec2.y(), vec2.z()).method_1029();
        return this.run(ctx, Optional.empty(), position, direction, bool);
    }

    public Optional<T> fromEntity(SpellContext ctx, EntityFragment e, Optional<BooleanFragment> bool) throws BlunderException {
        class_1297 entity = e.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder(this));
        class_243 position = entity.method_33571();
        class_243 direction = entity.method_5720();
        return this.run(ctx, Optional.of(entity), position, direction, bool);
    }

    public abstract Optional<T> run(SpellContext var1, Optional<class_1297> var2, class_243 var3, class_243 var4, Optional<BooleanFragment> var5) throws BlunderException;
}

