/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.tree;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.trick.tree.AbstractMetaTrick;
import dev.enjarai.trickster.spell.type.ArgType;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oshi.util.tuples.Pair;

public class LocateGlyphsTrick
extends AbstractMetaTrick<LocateGlyphsTrick> {
    public LocateGlyphsTrick() {
        super(Pattern.of(6, 7, 8, 2, 1, 0, 4, 8, 5, 2), Signature.of(FragmentType.SPELL_PART, ArgType.ANY, LocateGlyphsTrick::locate, FragmentType.NUMBER.listOfRet().listOfRet()));
    }

    public List<List<NumberFragment>> locate(SpellContext ctx, SpellPart spell, Fragment glyph) throws BlunderException {
        ArrayList<List<Integer>> addresses = new ArrayList<List<Integer>>();
        this.search(spell, glyph, addresses);
        return addresses.stream().map(address -> address.stream().map(NumberFragment::new).toList()).toList();
    }

    private void search(SpellPart spell, Fragment target, List<List<Integer>> addresses) {
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(new Pair((Object)new Integer[0], (Object)spell));
        while (!queue.isEmpty()) {
            Pair temp = (Pair)queue.poll();
            if (((SpellPart)temp.getB()).glyph.equals(target)) {
                addresses.add(Arrays.asList((Integer[])temp.getA()));
            }
            List<SpellPart> subParts = ((SpellPart)temp.getB()).subParts;
            for (int i = 0; i < subParts.size(); ++i) {
                Integer[] newAddress = Arrays.copyOfRange((Integer[])temp.getA(), 0, ((Integer[])temp.getA()).length + 1);
                newAddress[((Integer[])temp.getA()).length] = i;
                queue.add(new Pair((Object)newAddress, (Object)subParts.get(i)));
            }
        }
    }
}

