/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.cca.CasterComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ListArgType;
import dev.enjarai.trickster.spell.type.MapArgType;
import dev.enjarai.trickster.spell.type.OptionalArgType;
import dev.enjarai.trickster.spell.type.SimpleArgType;
import dev.enjarai.trickster.spell.type.Tuple2ArgType;
import dev.enjarai.trickster.spell.type.VariadicArgType;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.joml.Vector3dc;

public interface ArgType<T> {
    public static final SimpleArgType<Fragment> ANY = ArgType.simple(Fragment.class);

    public int argc(List<Fragment> var1);

    public T compose(Trick<?> var1, SpellContext var2, List<Fragment> var3);

    public boolean match(List<Fragment> var1);

    public ArgType<T> wardOf();

    public class_5250 asText();

    default public List<Fragment> isolate(int start, List<Fragment> fragments) {
        fragments = fragments.subList(start, fragments.size());
        return fragments.subList(0, this.argc(fragments));
    }

    default public boolean isolateAndMatch(List<Fragment> fragments) {
        if (this.argc(fragments) > fragments.size()) {
            return false;
        }
        return this.match(this.isolate(0, fragments));
    }

    default public ArgType<T> argType() {
        return this;
    }

    default public OptionalArgType<T> optionalOfArg() {
        return new OptionalArgType(this);
    }

    default public ListArgType<T> listOfArg() {
        return new ListArgType(this);
    }

    default public <K> MapArgType<T, K> mappedTo(ArgType<K> other) {
        return new MapArgType(this, other);
    }

    default public <T2> Tuple2ArgType<T, T2> pairedWith(ArgType<T2> other) {
        return new Tuple2ArgType(this, other);
    }

    default public VariadicArgType<T> variadicOfArg() {
        return new VariadicArgType(this, false, false);
    }

    public static <T extends Fragment> SimpleArgType<T> simple(Class<T> type) {
        return new SimpleArgType<T>(type);
    }

    public static void tryWard(Trick<?> trickSource, SpellContext triggerCtx, EntityFragment targetFragment, List<Fragment> fragments) {
        targetFragment.getEntity(triggerCtx).ifPresent(target -> {
            if (target instanceof class_3222) {
                class_3222 player = (class_3222)target;
                Optional<class_1297> triggerCaster = triggerCtx.source().getCaster();
                if (triggerCaster.map(c -> c.equals((Object)player)).orElse(false).booleanValue()) {
                    return;
                }
                Fragment sourceFragment = triggerCaster.map(EntityFragment::from).orElse(new VectorFragment((Vector3dc)triggerCtx.source().getPos()));
                HashMap<Pattern, SpellPart> charmMap = FragmentComponent.getUserMergedMap((class_1657)player, "charm", HashMap::empty);
                Option spell = charmMap.get((Object)trickSource.getPattern());
                CasterComponent caster = (CasterComponent)ModEntityComponents.CASTER.get((Object)player);
                spell.peek(s -> {
                    ModCriteria.TRIGGER_WARD.trigger(player);
                    caster.queueSpellAndCast((SpellPart)s, List.of(sourceFragment, new ListFragment(fragments)), Optional.empty());
                });
            }
        });
    }
}

