/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ListArgType<T>
implements ArgType<List<T>> {
    protected final ArgType<T> type;

    protected ListArgType(ArgType<T> type) {
        this.type = type;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return FragmentType.LIST.argc(fragments);
    }

    @Override
    public List<T> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        List<Fragment> list = ((ListFragment)FragmentType.LIST.compose((Trick)trick, ctx, (List)fragments)).fragments();
        int argc = this.type.argc(list);
        ArrayList<T> result = new ArrayList<T>();
        if (argc != 0) {
            for (int i = 0; i < list.size() / argc; ++i) {
                result.add(this.type.compose(trick, ctx, this.type.isolate(i * argc, list)));
            }
        }
        return result;
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        if (!FragmentType.LIST.match(fragments)) {
            return false;
        }
        List<Fragment> list = ((ListFragment)fragments.getFirst()).fragments();
        int argc = this.type.argc(list);
        if (argc == 0) {
            return false;
        }
        if (list.size() % argc != 0) {
            return false;
        }
        for (int i = 0; i < list.size() / argc; ++i) {
            if (this.type.match(this.type.isolate(i * argc, list))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArgType<List<T>> wardOf() {
        return new ListArgType<T>(this.type.wardOf());
    }

    @Override
    public class_5250 asText() {
        return class_2561.method_43470((String)"[").method_10852((class_2561)this.type.asText()).method_27693("]");
    }
}

