/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.MapFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class MapArgType<K, V>
implements ArgType<HashMap<K, V>> {
    protected final ArgType<K> keyType;
    protected final ArgType<V> valueType;

    public MapArgType(ArgType<K> keyType, ArgType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return FragmentType.MAP.argc(fragments);
    }

    @Override
    public HashMap<K, V> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        MapFragment map = (MapFragment)FragmentType.MAP.compose((Trick)trick, ctx, (List)fragments);
        HashMap result = HashMap.empty();
        for (Tuple2 entry : map.map()) {
            result = result.put(this.keyType.compose(trick, ctx, List.of((Fragment)entry._1)), this.valueType.compose(trick, ctx, List.of((Fragment)entry._2)));
        }
        return result;
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        if (!FragmentType.MAP.match(fragments)) {
            return false;
        }
        MapFragment map = (MapFragment)fragments.getFirst();
        int argcKey = this.keyType.argc(fragments);
        int argcValue = this.valueType.argc(fragments);
        if (argcKey != 1 || argcValue != 1) {
            return false;
        }
        for (Tuple2 entry : map.map()) {
            if (!this.keyType.match(List.of((Fragment)entry._1))) {
                return false;
            }
            if (this.valueType.match(List.of((Fragment)entry._2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArgType<HashMap<K, V>> wardOf() {
        return new MapArgType<K, V>(this.keyType.wardOf(), this.valueType.wardOf());
    }

    @Override
    public class_5250 asText() {
        return class_2561.method_43470((String)"{").method_10852((class_2561)this.keyType.asText()).method_27693(": ").method_10852((class_2561)this.valueType.asText()).method_27693("}");
    }
}

