/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_5250;

public class OptionalArgType<T>
implements ArgType<Optional<T>> {
    private final ArgType<T> type;

    public OptionalArgType(ArgType<T> type) {
        this.type = type;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return Math.min(fragments.size(), 1);
    }

    @Override
    public Optional<T> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        if (this.argc(fragments) == 0) {
            return Optional.empty();
        }
        if (fragments.getFirst() == VoidFragment.INSTANCE) {
            return Optional.empty();
        }
        return Optional.of(this.type.compose(trick, ctx, fragments));
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        if (this.argc(fragments) == 0) {
            return true;
        }
        if (fragments.getFirst() == VoidFragment.INSTANCE) {
            return true;
        }
        return this.type.match(fragments);
    }

    @Override
    public ArgType<Optional<T>> wardOf() {
        return new OptionalArgType<T>(this.type.wardOf());
    }

    @Override
    public class_5250 asText() {
        return this.type.asText().method_27693("?");
    }
}

