/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.type;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class VariadicArgType<T>
implements ArgType<List<T>> {
    protected final ArgType<T> type;
    protected final boolean require;
    protected final boolean unpack;

    public VariadicArgType(ArgType<T> type, boolean require, boolean unpack) {
        this.type = type;
        this.require = require;
        this.unpack = unpack;
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return fragments.size() - fragments.size() % this.type.argc(fragments);
    }

    @Override
    public List<T> compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        Fragment fragment;
        if (this.unpack && !fragments.isEmpty() && (fragment = fragments.getFirst()) instanceof ListFragment) {
            ListFragment list = (ListFragment)fragment;
            fragments = list.fragments();
        }
        int argc = this.type.argc(fragments);
        ArrayList<T> result = new ArrayList<T>();
        if (argc != 0) {
            for (int i = 0; i < fragments.size() / argc; ++i) {
                result.add(this.type.compose(trick, ctx, this.type.isolate(i * argc, fragments)));
            }
        }
        return result;
    }

    public VariadicArgType<T> require() {
        return new VariadicArgType<T>(this.type, true, this.unpack);
    }

    public VariadicArgType<T> unpack() {
        return new VariadicArgType<T>(this.type, this.require, true);
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        Fragment fragment;
        if (this.unpack && !fragments.isEmpty() && (fragment = fragments.getFirst()) instanceof ListFragment) {
            ListFragment list = (ListFragment)fragment;
            fragments = list.fragments();
        }
        if (this.require && fragments.isEmpty()) {
            return false;
        }
        int argc = this.type.argc(fragments);
        if (argc == 0) {
            return false;
        }
        if (fragments.size() % argc != 0) {
            return false;
        }
        for (int i = 0; i < fragments.size() / argc; ++i) {
            if (this.type.match(this.type.isolate(i * argc, fragments))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArgType<List<T>> wardOf() {
        return new VariadicArgType<T>(this.type.wardOf(), this.require, this.unpack);
    }

    @Override
    public class_5250 asText() {
        class_5250 typeText = this.type.asText();
        class_5250 text = class_2561.method_43473().method_10852((class_2561)typeText).method_27693("...");
        if (this.unpack) {
            text = text.method_27693(" | [").method_10852((class_2561)typeText).method_27693("]");
        }
        return text;
    }
}

