/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.util;

import dev.enjarai.trickster.spell.Fragment;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import java.util.List;

public class FuzzyUtils {
    public static <T1 extends Fragment, T2 extends Fragment> boolean fuzzyEquals(List<T1> a, List<T2> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (((Fragment)a.get(i)).fuzzyEquals((Fragment)b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <K extends Fragment, V extends Fragment> boolean fuzzyEquals(HashMap<K, V> a, HashMap<K, V> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Tuple2 kv : a) {
            if (((Boolean)b.get((Object)((Fragment)kv._1)).map(v -> ((Fragment)kv._2).fuzzyEquals((Fragment)v)).getOrElse(() -> false)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T extends Fragment> int fuzzyHash(List<T> items) {
        int result = 1;
        for (Fragment item : items) {
            result = 31 * result + item.fuzzyHash();
        }
        return result;
    }

    public static <T1 extends Fragment, T2 extends Fragment> int fuzzyHash(HashMap<T1, T2> map) {
        int result = 0;
        for (Tuple2 kv : map) {
            result += ((Fragment)kv._1).fuzzyHash() + ((Fragment)kv._2).fuzzyHash();
        }
        return result;
    }
}

