```json
{
  "title": "Vectors",
  "icon": "minecraft:arrow",
  "category": "trickster:distortions",
  "additional_search_terms": [
    "Primary Distortion",
    "Secondary Distortion",
    "Tertiary Distortion",
    "Absorption Distortion",
    "Magnitude Distortion",
    "Alignment Distortion",
    "Perpendicular Distortion",
    "Regularity Distortion",
    "Aligned Regularity Distortion"
  ]
}
```

While much vector math can be done with basic [arithmetic](^trickster:distortions/arithmetic) patterns, 
some operations require more specialized functionality.
This chapter provides some of these.

;;;;;

<|trick@trickster:templates|trick-id=trickster:extract_x|>

Returns the X component of the given vector.

;;;;;

<|trick@trickster:templates|trick-id=trickster:extract_y|>

Returns the Y component of the given vector.

;;;;;

<|trick@trickster:templates|trick-id=trickster:extract_z|>

Returns the Z component of the given vector.

;;;;;

<|trick@trickster:templates|trick-id=trickster:merge_vector|>

Merges three input numbers into a vector.

;;;;;

<|trick@trickster:templates|trick-id=trickster:length|>

Returns the length of the given vector.

;;;;;

<|trick@trickster:templates|trick-id=trickster:dot_product|>

Returns the dot product of the given vectors.

;;;;;

<|trick@trickster:templates|trick-id=trickster:cross_product|>

Returns the cross product of the given vectors.

;;;;;

<|trick@trickster:templates|trick-id=trickster:normalize|>

Normalizes the given vector to a length of one.

;;;;;

<|trick@trickster:templates|trick-id=trickster:align_vector|>

Normalizes the given vector to a length of one and aligns it to the nearest cardinal axis.
