```json
{
  "title": "Knots",
  "icon": "trickster:emerald_knot",
  "category": "trickster:items",
  "ordinal": 10
}
```

Knots are gemstones encased in glass orbs that hold a certain
amount of [Mana](^trickster:concepts/mana) based on the rarity of the gem they're made from.


Some gems have unique properties when made into a Knot, such as Amethyst,
which, unlike other gems, already contains Mana when converted,
but cannot be recharged naturally.

;;;;;

Naturally recharging a Knot is done by exposing it to the night sky.
It will charge most quickly at or near a full or new moon, but not at all when exactly in between.


To count as being exposed, a Knot must either be thrown on the ground or placed in a 
[Charging Array](^trickster:items/charging_array) or [Spell Construct](^trickster:items/spell_construct) 
with a clear view of the sky.
Rechargeable Knots thrown on the ground will not despawn.

;;;;;

Most gems or crystals can be made into Knots using
[Ploy of the Moon Watcher](^trickster:ploys/mana#2).


This ploy optionally takes two arguments, 
one [slot](^trickster:delusions_ingresses/inventory#4) containing a gem, another holding a Glass Block.
If the latter isn't provided, the first available Glass Block will be used.
If the former isn't provided, an Amethyst Shard will be used in the same manner. 
As such, it is not possible to create non-amethyst Knots without providing a slot reference.

;;;;;

<|item-tag@trickster:templates|tag-id=trickster:spoilerless_mana_knots|>

A few known Knot types are:

- __Amethyst__\
Creation cost: none
Capacity: 128 G
- __Emerald__\
Creation cost: 512 G
Capacity: 1024 G
- __Diamond__\
Creation cost: 8192 G
Capacity: 16384 G

;;;;;

Other gems and crystals may be able to be turned into Knots as well, 
but this must be determined on a case-by-case basis.
