/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.enjarai.trickster.cca.CasterComponent;
import dev.enjarai.trickster.cca.DisplacementComponent;
import dev.enjarai.trickster.cca.EntityScaleComponent;
import dev.enjarai.trickster.cca.EntityWeightComponent;
import dev.enjarai.trickster.cca.GraceComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.net.GrabClipboardSpellPacket;
import dev.enjarai.trickster.net.ModNetworking;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.trick.Tricks;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.joml.Vector3dc;

public class TricksterCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trickster").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"killSpells").requires(class_2168::method_43737)).executes(TricksterCommand::killSpells))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"exportSpell").requires(class_2168::method_43737)).executes(TricksterCommand::exportSpell))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"importSpell").requires(class_2168::method_43737)).requires(s -> s.method_9259(2))).executes(TricksterCommand::importSpell))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fillKnot").requires(class_2168::method_43737)).requires(s -> s.method_9259(2))).executes(TricksterCommand::fillKnot))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"weight").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"weight", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(context -> TricksterCommand.setWeight((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"weight"), List.of(((class_2168)context.getSource()).method_9229())))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).executes(context -> TricksterCommand.setWeight((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"weight"), class_2186.method_9317((CommandContext)context, (String)"target"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"scale").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0625, (double)8.0)).executes(context -> TricksterCommand.setScale((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"), List.of(((class_2168)context.getSource()).method_9229())))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).executes(context -> TricksterCommand.setScale((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"), class_2186.method_9317((CommandContext)context, (String)"target"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"offset", (ArgumentType)class_2277.method_9737()).executes(context -> TricksterCommand.teleport((CommandContext<class_2168>)context, class_2277.method_9736((CommandContext)context, (String)"offset"), List.of(((class_2168)context.getSource()).method_9229())))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).executes(context -> TricksterCommand.teleport((CommandContext<class_2168>)context, class_2277.method_9736((CommandContext)context, (String)"offset"), class_2186.method_9317((CommandContext)context, (String)"target"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"allSignatures").requires(class_2168::method_43737)).executes(TricksterCommand::showAllSignatures)));
    }

    private static int exportSpell(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = player.method_5998(hand);
            Optional<SpellPart> spell = FragmentComponent.getSpellPart(stack);
            if (!spell.isPresent()) continue;
            String string = spell.get().toBase64();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Base64 spell string: ").method_10852((class_2561)class_2561.method_43470((String)string).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, string)))), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be holding an item with an inscribed spell."));
        return 0;
    }

    private static int importSpell(CommandContext<class_2168> context) throws CommandSyntaxException {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Importing spell from clipboard..."), true);
        ModNetworking.CHANNEL.serverHandle((class_1657)((class_2168)context.getSource()).method_44023()).send((Record)new GrabClipboardSpellPacket());
        return 1;
    }

    public static void importCallback(class_3222 player, SpellPart spell) {
        if (player.method_5687(2)) {
            class_1799 stack = ModItems.SCROLL_AND_QUILL.method_7854();
            stack.method_57379(ModComponents.FRAGMENT, (Object)new FragmentComponent(spell));
            if (!player.method_7270(stack)) {
                player.method_7328(stack, false);
            }
            player.method_43496((class_2561)class_2561.method_43470((String)"Gave 1 scroll"));
        }
    }

    private static int killSpells(CommandContext<class_2168> context) throws CommandSyntaxException {
        ((CasterComponent)((class_2168)context.getSource()).method_9207().getComponent(ModEntityComponents.CASTER)).killAll();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Killed running spells."), true);
        return 1;
    }

    private static int fillKnot(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        for (class_1268 hand : class_1268.values()) {
            class_1799 stack = player.method_5998(hand);
            ManaComponent component = (ManaComponent)stack.method_57824(ModComponents.MANA);
            if (component == null) continue;
            MutableManaPool pool = component.pool().makeClone((class_1937)((class_2168)context.getSource()).method_9225());
            pool.refill(pool.getMax((class_1937)((class_2168)context.getSource()).method_9225()), (class_1937)((class_2168)context.getSource()).method_9225());
            stack.method_57379(ModComponents.MANA, (Object)component.with(pool));
            player.method_43496((class_2561)class_2561.method_43470((String)"Mana refilled"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be holding an item capable of storing mana."));
        return 0;
    }

    private static int setWeight(CommandContext<class_2168> context, double weight, Collection<? extends class_1297> targets) throws CommandSyntaxException {
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            ((EntityWeightComponent)ModEntityComponents.WEIGHT.get((Object)class_12972)).setWeight(weight);
            ((GraceComponent)ModEntityComponents.GRACE.get((Object)class_12972)).triggerGrace("weight", 100);
        }
        return 0;
    }

    private static int setScale(CommandContext<class_2168> context, double scale, Collection<? extends class_1297> targets) throws CommandSyntaxException {
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) continue;
            ((EntityScaleComponent)ModEntityComponents.SCALE.get((Object)class_12972)).setScale(scale);
            ((GraceComponent)ModEntityComponents.GRACE.get((Object)class_12972)).triggerGrace("scale", 100);
        }
        return 0;
    }

    private static int teleport(CommandContext<class_2168> context, class_243 offset, Collection<? extends class_1297> targets) throws CommandSyntaxException {
        for (class_1297 class_12972 : targets) {
            ((DisplacementComponent)ModEntityComponents.DISPLACEMENT.get((Object)class_12972)).modify((Vector3dc)offset.toVector3d());
        }
        return 0;
    }

    private static int showAllSignatures(CommandContext<class_2168> context) throws CommandSyntaxException {
        Tricks.REGISTRY.method_10220().forEach(t -> t.getSignatures().forEach(h -> ((class_2168)context.getSource()).method_9226(() -> t.getName().method_27693(": ").method_10852((class_2561)h.asText()), false)));
        return 0;
    }
}

