/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.block;

import dev.enjarai.trickster.block.ModBlocks;
import dev.enjarai.trickster.block.ModularSpellConstructBlock;
import dev.enjarai.trickster.block.SpellCastingBlockEntity;
import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.item.SpellCoreItem;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.CrowMind;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.SpellExecutionManager;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.execution.executor.ErroredSpellExecutor;
import dev.enjarai.trickster.spell.execution.source.BlockSpellSource;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModularSpellConstructBlockEntity
extends class_2586
implements class_1263,
CrowMind,
SpellExecutionManager,
SpellCastingBlockEntity {
    public static final KeyedEndec<Fragment> CROW_MIND_ENDEC = Fragment.ENDEC.keyed("crow_mind", () -> VoidFragment.INSTANCE);
    public static final KeyedEndec<List<Optional<SpellExecutor>>> EXECUTORS_ENDEC = SpellExecutor.ENDEC.optionalOf().listOf().keyed("executors", () -> null);
    public static final KeyedEndec<List<Optional<SpellExecutor>>> EXECUTORS_NET_ENDEC = SpellExecutor.NET_ENDEC.optionalOf().listOf().keyed("executors", List.of());
    public final class_2371<Optional<SpellExecutor>> executors = class_2371.method_10213((int)4, Optional.empty());
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private Fragment crowMind = VoidFragment.INSTANCE;
    public int age;

    public ModularSpellConstructBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.MODULAR_SPELL_CONSTRUCT_ENTITY, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.clear();
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.crowMind = (Fragment)nbt.get(CROW_MIND_ENDEC);
        this.executors.clear();
        List newExecutors = (List)nbt.get(EXECUTORS_ENDEC);
        if (newExecutors == null) {
            newExecutors = (List)nbt.get(EXECUTORS_NET_ENDEC);
        }
        for (int i = 0; i < Math.min(newExecutors.size(), 4); ++i) {
            this.executors.set(i, (Object)((Optional)newExecutors.get(i)));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.writeCommonNbt(nbt, registryLookup);
        nbt.put(CROW_MIND_ENDEC, (Object)this.crowMind);
        nbt.put(EXECUTORS_ENDEC, this.executors);
    }

    protected void writeNetNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.writeCommonNbt(nbt, registryLookup);
        nbt.put(EXECUTORS_NET_ENDEC, this.executors);
    }

    protected void writeCommonNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory, (boolean)true, (class_7225.class_7874)registryLookup);
    }

    public void tick() {
        ++this.age;
        boolean updateClient = false;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            BlockSpellSource<ModularSpellConstructBlockEntity> source = new BlockSpellSource<ModularSpellConstructBlockEntity>(serverWorld, this.method_11016(), this);
            for (int i = 0; i < this.inventory.size(); ++i) {
                class_1799 stack = (class_1799)this.inventory.get(i);
                int executorSlot = i - 1;
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof SpellCoreItem) {
                    SpellCoreItem item = (SpellCoreItem)class_17922;
                    if (((Optional)this.executors.get(executorSlot)).isPresent()) {
                        SpellExecutor executor = (SpellExecutor)((Optional)this.executors.get(executorSlot)).get();
                        Optional<Object> error = Optional.empty();
                        if (executor instanceof ErroredSpellExecutor) continue;
                        try {
                            if (executor.run(source, new TickData().withSlot(executorSlot).withBonusExecutions(item.getExecutionBonus())).isPresent()) {
                                this.executors.set(executorSlot, Optional.empty());
                                updateClient = true;
                            }
                        }
                        catch (BlunderException blunder) {
                            error = Optional.of(blunder.createMessage().method_27693(" (").method_10852(executor.getDeepestState().formatStackTrace()).method_27693(")"));
                        }
                        catch (Throwable e2) {
                            error = Optional.of(class_2561.method_43470((String)("Uncaught exception in spell: " + e2.getMessage())).method_27693(" (").method_10852(executor.getDeepestState().formatStackTrace()).method_27693(")"));
                        }
                        error.ifPresent(e -> this.executors.set(executorSlot, Optional.of(new ErroredSpellExecutor(executor.spell(), (class_2561)e))));
                        if (error.isPresent()) {
                            this.playCastSound(serverWorld, this.method_11016(), 0.5f, 0.1f);
                            updateClient = true;
                        }
                    }
                }
                ManaComponent.tryRecharge(serverWorld, this.method_11016().method_46558().method_1019(new class_243(((class_2350)this.method_11010().method_11654((class_2769)ModularSpellConstructBlock.FACING)).method_23955().mul(0.3f, new Vector3f()))), stack);
            }
            if (updateClient) {
                this.markDirtyAndUpdateClients();
            } else {
                this.method_5431();
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.writeNetNbt(nbt, registryLookup);
        return nbt;
    }

    public void method_5448() {
        this.inventory.clear();
        this.markDirtyAndUpdateClients();
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot < this.inventory.size()) {
            class_1799 itemStack = (class_1799)this.inventory.get(slot);
            this.inventory.set(slot, (Object)class_1799.field_8037);
            this.markDirtyAndUpdateClients();
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                class_19372 = itemStack.method_7909();
                if (class_19372 instanceof SpellCoreItem) {
                    SpellCoreItem item = (SpellCoreItem)class_19372;
                    Optional perhapsExecutor = (Optional)this.executors.get(slot - 1);
                    if (item.onRemoved(world, this.method_11016(), itemStack, perhapsExecutor)) {
                        return class_1799.field_8037;
                    }
                    this.executors.set(slot - 1, Optional.empty());
                }
            }
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 1);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0 ? stack.method_31573(ModItems.MANA_KNOTS) : stack.method_7909() instanceof SpellCoreItem) {
            Fragment fragment;
            FragmentComponent fragment2;
            if (stack.method_7909() instanceof SpellCoreItem && (fragment2 = (FragmentComponent)stack.method_57824(ModComponents.FRAGMENT)) != null && (fragment = fragment2.value()) instanceof SpellPart) {
                SpellPart spell = (SpellPart)fragment;
                DefaultSpellExecutor executor = new DefaultSpellExecutor(spell, List.of());
                this.executors.set(slot - 1, Optional.of(executor));
            }
            this.inventory.set(slot, (Object)stack);
            this.markDirtyAndUpdateClients();
        } else if (stack.method_7960()) {
            this.method_5434(slot, 1);
        }
    }

    public void markDirtyAndUpdateClients() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return stack.method_7960() || (slot == 0 ? stack.method_31573(ModItems.MANA_KNOTS) : stack.method_7909() instanceof SpellCoreItem) && this.method_5438(slot).method_7960();
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        ((class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.inventory);
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(this.inventory));
    }

    @Override
    public void setCrowMind(Fragment fragment) {
        this.crowMind = fragment;
        this.markDirtyAndUpdateClients();
    }

    @Override
    public Fragment getCrowMind() {
        return this.crowMind;
    }

    @Override
    public int queue(SpellExecutor executor) {
        for (int i = 1; i < this.inventory.size(); ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (!(stack.method_7909() instanceof SpellCoreItem) || !((Optional)this.executors.get(i - 1)).isEmpty() && !(((Optional)this.executors.get(i - 1)).get() instanceof ErroredSpellExecutor)) continue;
            this.executors.set(i - 1, Optional.of(executor));
            this.markDirtyAndUpdateClients();
            return i - 1;
        }
        return -1;
    }

    @Override
    public void killAll() {
        this.executors.clear();
    }

    @Override
    public boolean kill(int index) {
        if (((Optional)this.executors.get(index)).isPresent()) {
            this.executors.set(index, Optional.empty());
            return true;
        }
        return false;
    }
}

