/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.block;

import dev.enjarai.trickster.block.ModBlocks;
import dev.enjarai.trickster.block.SpellCastingBlockEntity;
import dev.enjarai.trickster.block.SpellColoredBlockEntity;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.CrowMind;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.execution.executor.ErroredSpellExecutor;
import dev.enjarai.trickster.spell.execution.source.BlockSpellSource;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import io.wispforest.endec.impl.KeyedEndec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SpellConstructBlockEntity
extends class_2586
implements SpellColoredBlockEntity,
class_1263,
CrowMind,
SpellCastingBlockEntity {
    public static final KeyedEndec<Fragment> CROW_MIND_ENDEC = Fragment.ENDEC.keyed("crow_mind", () -> VoidFragment.INSTANCE);
    public static final KeyedEndec<SpellExecutor> EXECUTOR_ENDEC = SpellExecutor.ENDEC.nullableOf().keyed("executor", () -> null);
    public static final KeyedEndec<SpellExecutor> EXECUTOR_NET_ENDEC = SpellExecutor.NET_ENDEC.nullableOf().keyed("executor", () -> null);
    public int age;
    public Fragment crowMind = VoidFragment.INSTANCE;
    public int[] colors = new int[]{0xFFFFFF};
    private class_1799 stack = class_1799.field_8037;
    public SpellExecutor executor = null;

    public SpellConstructBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.SPELL_CONSTRUCT_ENTITY, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.stack = nbt.method_10545("stack") ? (class_1799)class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10580("stack")).orElseThrow() : class_1799.field_8037;
        this.crowMind = (Fragment)nbt.get(CROW_MIND_ENDEC);
        this.colors = nbt.method_10561("colors");
        SpellExecutor spellExecutor = this.executor = nbt.method_10577("net") ? (SpellExecutor)nbt.get(EXECUTOR_NET_ENDEC) : (SpellExecutor)nbt.get(EXECUTOR_ENDEC);
        if (this.colors.length == 0) {
            this.colors = new int[]{0xFFFFFF};
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.writeCommonNbt(nbt, registryLookup);
        nbt.put(CROW_MIND_ENDEC, (Object)this.crowMind);
        nbt.put(EXECUTOR_ENDEC, (Object)this.executor);
    }

    protected void writeNetNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.writeCommonNbt(nbt, registryLookup);
        nbt.method_10556("net", true);
        nbt.put(EXECUTOR_NET_ENDEC, (Object)this.executor);
    }

    protected void writeCommonNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.stack.method_7960()) {
            nbt.method_10566("stack", this.stack.method_57376(registryLookup, (class_2520)new class_2487()));
        }
        nbt.method_10539("colors", this.colors);
    }

    public void tick() {
        ++this.age;
        boolean updateClient = false;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.executor != null) {
                BlockSpellSource<SpellConstructBlockEntity> source = new BlockSpellSource<SpellConstructBlockEntity>(serverWorld, this.method_11016(), this);
                if (!(this.executor instanceof ErroredSpellExecutor)) {
                    Optional<Object> error = Optional.empty();
                    try {
                        if (this.executor.run(source).isPresent()) {
                            this.executor = null;
                            updateClient = true;
                        }
                    }
                    catch (BlunderException blunder) {
                        error = Optional.of(blunder.createMessage().method_27693(" (").method_10852(this.executor.getDeepestState().formatStackTrace()).method_27693(")"));
                    }
                    catch (Exception e2) {
                        error = Optional.of(class_2561.method_43470((String)("Uncaught exception in spell: " + e2.getMessage())).method_27693(" (").method_10852(this.executor.getDeepestState().formatStackTrace()).method_27693(")"));
                    }
                    error.ifPresent(e -> {
                        this.executor = new ErroredSpellExecutor(this.executor.spell(), (class_2561)e);
                    });
                    if (error.isPresent()) {
                        this.playCastSound(serverWorld, this.method_11016(), 0.5f, 0.1f);
                        updateClient = true;
                    }
                }
            }
            ManaComponent.tryRecharge(serverWorld, this.method_11016().method_46558(), this.stack);
            if (updateClient) {
                this.markDirtyAndUpdateClients();
            } else {
                this.method_5431();
            }
        }
    }

    public void refreshExecutor() {
        Fragment fragment;
        if (this.method_58693().method_57832(ModComponents.FRAGMENT) && (fragment = ((FragmentComponent)this.method_58693().method_57829(ModComponents.FRAGMENT)).value()) instanceof SpellPart) {
            SpellPart spell = (SpellPart)fragment;
            if (this.executor == null || !spell.equals(this.executor.spell()) || this.executor instanceof ErroredSpellExecutor) {
                this.executor = new DefaultSpellExecutor(spell, List.of());
                this.markDirtyAndUpdateClients();
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.writeNetNbt(nbt, registryLookup);
        return nbt;
    }

    @Override
    public int[] getColors() {
        return this.colors;
    }

    @Override
    public void setColors(int[] colors) {
        this.colors = colors;
        this.markDirtyAndUpdateClients();
    }

    public void method_5448() {
        this.stack = class_1799.field_8037;
        this.markDirtyAndUpdateClients();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public class_1799 method_5438(int slot) {
        if (slot != 0) {
            return class_1799.field_8037;
        }
        return this.stack;
    }

    public boolean method_5442() {
        return this.stack.method_7960();
    }

    public class_1799 method_5441(int slot) {
        if (slot != 0) {
            return class_1799.field_8037;
        }
        class_1799 result = this.stack.method_51164();
        this.markDirtyAndUpdateClients();
        return result;
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot != 0) {
            return class_1799.field_8037;
        }
        class_1799 result = this.stack.method_7971(amount);
        this.markDirtyAndUpdateClients();
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot != 0) {
            return;
        }
        this.stack = stack;
        this.markDirtyAndUpdateClients();
    }

    public int method_5439() {
        return 1;
    }

    @Override
    public void setCrowMind(Fragment fragment) {
        this.crowMind = fragment;
        this.markDirtyAndUpdateClients();
    }

    @Override
    public Fragment getCrowMind() {
        return this.crowMind;
    }

    public void markDirtyAndUpdateClients() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        }
    }
}

