/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.cca;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_269;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class MessageHandlerComponent
implements ServerTickingComponent {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<Message> messages = new ArrayList<Message>();
    private final class_269 provider;
    private final Optional<MinecraftServer> server;

    public MessageHandlerComponent(class_269 provider, @Nullable MinecraftServer server) {
        this.provider = provider;
        this.server = Optional.ofNullable(server);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void serverTick() {
        for (Listener listener : this.listeners) {
            ArrayList<Fragment> result = new ArrayList<Fragment>();
            for (Message message : this.messages) {
                if (!message.key.match(listener.key)) continue;
                result.add(message.value);
            }
            if (result.size() <= 0) continue;
            listener.consumer.accept(new ListFragment(result));
        }
        this.listeners.clear();
        this.messages.clear();
    }

    public void await(Key key, Consumer<ListFragment> consumer) {
        this.listeners.add(new Listener(key, consumer));
    }

    public void send(Key key, Fragment value) {
        this.messages.add(new Message(key, value.applyEphemeral()));
    }

    private record Listener(Key key, Consumer<ListFragment> consumer) {
    }

    private record Message(Key key, Fragment value) {
    }

    public static interface Key {
        public boolean match(Key var1);

        public record Broadcast(class_5321<class_1937> world, Vector3d pos, double extraRange) implements Key
        {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean match(Key other) {
                if (!(other instanceof Broadcast)) return false;
                Broadcast broadcast = (Broadcast)other;
                if (!broadcast.world.equals(this.world)) return false;
                if (!(broadcast.pos.distanceSquared((Vector3dc)this.pos) <= 256.0 + Math.pow(broadcast.extraRange, 2.0) + Math.pow(this.extraRange, 2.0))) return false;
                return true;
            }
        }

        public record Channel(UUID uuid) implements Key
        {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean match(Key other) {
                if (!(other instanceof Channel)) return false;
                Channel channel = (Channel)other;
                if (!channel.uuid.equals(this.uuid)) return false;
                return true;
            }
        }
    }
}

