/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.cca;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.cca.ModGlobalComponents;
import dev.enjarai.trickster.spell.mana.SimpleManaPool;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.KeyedEndec;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class SharedManaComponent
implements AutoSyncedComponent {
    private static final KeyedEndec<Map<UUID, SimpleManaPool>> POOLS_ENDEC = new KeyedEndec("pools", Endec.map(EndecTomfoolery.UUID, SimpleManaPool.ENDEC), new HashMap());
    private final Map<UUID, SimpleManaPool> pools = new HashMap<UUID, SimpleManaPool>();
    private final Map<UUID, List<UUID>> subscribers = new HashMap<UUID, List<UUID>>();
    private final class_269 provider;
    private final Optional<MinecraftServer> server;

    public SharedManaComponent(class_269 provider, @Nullable MinecraftServer server) {
        this.provider = provider;
        this.server = Optional.ofNullable(server);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        return this.subscribers.containsKey(player.method_5667()) && !this.subscribers.get(player.method_5667()).isEmpty();
    }

    public void writeSyncPacket(class_9129 buf, class_3222 player) {
        List<UUID> uuids = this.subscribers.get(player.method_5667());
        buf.write(POOLS_ENDEC.endec(), this.pools.entrySet().stream().filter(entry -> uuids.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public void applySyncPacket(class_9129 buf) {
        this.pools.putAll((Map)buf.read(POOLS_ENDEC.endec()));
    }

    public UUID allocate(SimpleManaPool pool) {
        UUID uuid = UUID.randomUUID();
        if (this.server.isPresent()) {
            SimpleManaPool finalPool = pool;
            pool = ((PoolState)this.server.get().method_30002().method_17983().method_17924(new class_18.class_8645(() -> new PoolState(finalPool), PoolState::readNbt, class_4284.field_19212), "trickster/shared_mana_pool/" + String.valueOf(uuid))).getPool();
        }
        this.pools.put(uuid, pool);
        return uuid;
    }

    public Optional<SimpleManaPool> get(UUID uuid) {
        this.server.ifPresent(server -> {
            PoolState data;
            if (!this.pools.containsKey(uuid) && (data = (PoolState)server.method_30002().method_17983().method_20786(PoolState.TYPE, "trickster/shared_mana_pool/" + String.valueOf(uuid))) != null) {
                this.pools.put(uuid, data.getPool());
            }
        });
        return Optional.ofNullable(this.pools.get(uuid));
    }

    public void subscribe(class_3222 player, UUID uuid) {
        this.server.ifPresent(server -> {
            if (this.get(uuid).isPresent()) {
                UUID playerUuid = player.method_5667();
                List<UUID> subscriptions = this.subscribers.get(playerUuid);
                if (subscriptions == null) {
                    subscriptions = new ArrayList<UUID>();
                }
                subscriptions.add(uuid);
                this.subscribers.put(playerUuid, subscriptions);
                ModGlobalComponents.SHARED_MANA.sync((Object)this.provider);
            }
        });
    }

    private static class PoolState
    extends class_18 {
        private static final KeyedEndec<SimpleManaPool> ENDEC = new KeyedEndec("pool", SimpleManaPool.ENDEC, (Object)SimpleManaPool.getSingleUse(0.0f));
        public static final class_18.class_8645<PoolState> TYPE = new class_18.class_8645(() -> new PoolState(SimpleManaPool.getSingleUse(0.0f)), PoolState::readNbt, class_4284.field_19212);
        private final SimpleManaPool pool;

        private PoolState(SimpleManaPool pool) {
            this.pool = pool;
        }

        public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
            nbt.put(ENDEC, (Object)this.pool);
            return nbt;
        }

        public void method_17919(File file, class_7225.class_7874 registryLookup) {
            file.getParentFile().mkdirs();
            this.method_78(true);
            super.method_17919(file, registryLookup);
        }

        public SimpleManaPool getPool() {
            return this.pool;
        }

        public static PoolState readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
            return new PoolState((SimpleManaPool)nbt.get(ENDEC));
        }
    }
}

