/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.data.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.data.CompleteJsonDataLoader;
import dev.enjarai.trickster.mixin.accessor.StateAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import nl.enjarai.cicada.api.util.random.RandomUtil;
import nl.enjarai.cicada.api.util.random.Weighted;

public abstract class BlockConversionLoader
extends CompleteJsonDataLoader
implements IdentifiableResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final class_7225.class_7874 registryLookup;
    private final String type;
    protected ImmutableMap<class_2248, List<WeightedValue>> conversions = ImmutableMap.of();

    public BlockConversionLoader(String dataType, class_7225.class_7874 registryLookup) {
        super(GSON, "conversion/" + dataType);
        this.registryLookup = registryLookup;
        this.type = dataType;
    }

    public class_2960 getFabricId() {
        return Trickster.id("conversion", this.type);
    }

    protected void apply(Map<class_2960, List<JsonElement>> prepared, class_3300 manager, class_3695 profiler) {
        class_7225.class_7226 lookup = this.registryLookup.method_46762(class_7924.field_41254);
        HashMap<class_2248, List> map = new HashMap<class_2248, List>();
        prepared.forEach((identifier, jsonElements) -> {
            class_2248 source = (class_2248)lookup.method_46747(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)identifier)).comp_349();
            map.compute(source, (block, weightedValues) -> {
                List values = Objects.requireNonNullElseGet(weightedValues, ArrayList::new);
                for (JsonElement jsonElement : jsonElements) {
                    Replaceable replaceable = (Replaceable)Replaceable.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
                    if (replaceable.replace) {
                        values.clear();
                    }
                    values.addAll(replaceable.conversions);
                }
                return values;
            });
        });
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((block, weightedValues) -> builder.put(block, List.copyOf(weightedValues)));
        this.conversions = builder.build();
    }

    public boolean convert(class_2248 block, class_1937 world, class_2338 pos) {
        class_2586 blockEntity;
        List values = (List)this.conversions.get((Object)block);
        if (values == null) {
            return false;
        }
        Optional perhapsWeightedValue = RandomUtil.chooseWeighted((Collection)values);
        if (perhapsWeightedValue.isEmpty()) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)perhapsWeightedValue.get();
        class_2680 blockState = class_2248.method_9510((class_2680)weightedValue.state(), (class_1936)world, (class_2338)pos);
        if (blockState.method_26215()) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
        }
        if (weightedValue.keepProperties.isPresent()) {
            Function<String, Boolean> checker;
            Either<List<String>, Boolean> either = weightedValue.keepProperties.get();
            if (either.right().isPresent()) {
                boolean shouldKeepAll = (Boolean)either.right().get();
                checker = name -> shouldKeepAll;
            } else {
                List toKeep = (List)either.left().get();
                checker = toKeep::contains;
            }
            class_2680 oldState = world.method_8320(pos);
            for (class_2769 property : blockState.method_11656().keySet()) {
                if (!checker.apply(property.method_11899()).booleanValue() || !oldState.method_28498(property)) continue;
                blockState = this.propertyFromOldBlock(blockState, oldState, property);
            }
        }
        if (blockState.method_26227().method_39360((class_3611)class_3612.field_15910) && world.method_8597().comp_644()) {
            if (blockState.method_27852(class_2246.field_10382)) {
                blockState = class_2246.field_10124.method_9564();
            } else {
                Optional perhapsWaterlogged = blockState.method_28500((class_2769)class_2741.field_12508);
                if (perhapsWaterlogged.isPresent() && ((Boolean)perhapsWaterlogged.get()).booleanValue()) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
            }
        }
        if (!world.method_8501(pos, blockState)) {
            return false;
        }
        world.method_33596(null, (class_6880)class_5712.field_28733, pos);
        if (weightedValue.nbt().isPresent() && (blockEntity = world.method_8321(pos)) != null) {
            blockEntity.method_58690(weightedValue.nbt().get(), (class_7225.class_7874)world.method_30349());
        }
        return true;
    }

    private <T extends Comparable<T>> class_2680 propertyFromOldBlock(class_2680 newState, class_2680 oldState, class_2769<T> property) {
        return (class_2680)newState.method_11657(property, oldState.method_11654(property));
    }

    public record WeightedValue(class_2680 state, Optional<Either<List<String>, Boolean>> keepProperties, Optional<class_2487> nbt, int weight) implements Weighted
    {
        public static final MapCodec<class_2680> BLOCK_STATE_CODEC = class_7923.field_41175.method_39673().dispatchMap("id", state -> (class_2248)((StateAccessor)state).getOwner(), owner -> {
            class_2680 state = owner.method_9564();
            if (state.method_11656().isEmpty()) {
                return MapCodec.unit((Object)state);
            }
            return ((StateAccessor)state).getCodec().codec().optionalFieldOf("properties").xmap(optional -> optional.orElse(state), Optional::of);
        }).stable();
        public static final Codec<WeightedValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.of(WeightedValue::state, BLOCK_STATE_CODEC), (App)Codec.either((Codec)Codec.STRING.listOf(), (Codec)Codec.BOOL).optionalFieldOf("keepProperties").forGetter(WeightedValue::keepProperties), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(WeightedValue::nbt), (App)Codec.INT.fieldOf("weight").forGetter(WeightedValue::weight)).apply((Applicative)instance, WeightedValue::new));

        public double getWeight() {
            return this.weight;
        }
    }

    public record Replaceable(boolean replace, List<WeightedValue> conversions) {
        public static final Codec<Replaceable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(Replaceable::replace), (App)WeightedValue.CODEC.listOf().fieldOf("conversions").forGetter(Replaceable::conversions)).apply((Applicative)instance, Replaceable::new));
    }
}

