/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.datagen.provider;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import dev.enjarai.trickster.data.conversion.BlockConversionLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class BlockConversionProvider
implements class_2405 {
    protected final class_7784.class_7489 pathResolver;
    private final String type;
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;
    private final Map<class_2960, Builder> builders = Maps.newLinkedHashMap();

    public BlockConversionProvider(FabricDataOutput output, String type, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "conversion/" + type);
        this.registryLookupFuture = registryLookupFuture;
        this.type = type;
    }

    protected abstract void configure(class_7225.class_7874 var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.getRegistryLookupFuture().thenCompose(wrapperLookup -> CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
            class_2960 identifier = (class_2960)entry.getKey();
            List<BlockConversionLoader.WeightedValue> values = ((Builder)entry.getValue()).build();
            Path path = this.pathResolver.method_44107(identifier);
            return class_2405.method_53496((class_7403)writer, (class_7225.class_7874)wrapperLookup, BlockConversionLoader.Replaceable.CODEC, (Object)new BlockConversionLoader.Replaceable(false, values), (Path)path);
        }).toArray(CompletableFuture[]::new)));
    }

    protected CompletableFuture<class_7225.class_7874> getRegistryLookupFuture() {
        return this.registryLookupFuture.thenApply(lookup -> {
            this.builders.clear();
            this.configure((class_7225.class_7874)lookup);
            return lookup;
        });
    }

    protected Builder getOrCreateConversion(class_2248 source) {
        class_2960 id = class_7923.field_41175.method_10221((Object)source);
        return this.builders.computeIfAbsent(id, identifier -> Builder.create());
    }

    public String method_10321() {
        return "Block Conversion (" + this.type + ")";
    }

    public static class Builder {
        private final List<BlockConversionLoader.WeightedValue> entries = new ArrayList<BlockConversionLoader.WeightedValue>();

        public static Builder create() {
            return new Builder();
        }

        public List<BlockConversionLoader.WeightedValue> build() {
            return List.copyOf(this.entries);
        }

        public Builder add(class_2248 block, int weight) {
            this.add(block.method_9564(), weight);
            return this;
        }

        public Builder add(class_2680 state, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.empty(), Optional.empty(), weight));
            return this;
        }

        public Builder add(class_2248 block, List<String> keepProperties, int weight) {
            this.add(block.method_9564(), keepProperties, weight);
            return this;
        }

        public Builder add(class_2680 state, List<String> keepProperties, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.of(Either.left(keepProperties)), Optional.empty(), weight));
            return this;
        }

        public Builder add(class_2248 block, boolean keepProperties, int weight) {
            this.add(block.method_9564(), keepProperties, weight);
            return this;
        }

        public Builder add(class_2680 state, boolean keepProperties, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.of(Either.right((Object)keepProperties)), Optional.empty(), weight));
            return this;
        }

        public Builder add(class_2248 block, class_2487 nbt, int weight) {
            return this.add(block.method_9564(), nbt, weight);
        }

        public Builder add(class_2680 state, class_2487 nbt, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.empty(), Optional.ofNullable(nbt), weight));
            return this;
        }

        public Builder add(class_2248 block, List<String> keepProperties, class_2487 nbt, int weight) {
            return this.add(block.method_9564(), keepProperties, nbt, weight);
        }

        public Builder add(class_2680 state, List<String> keepProperties, class_2487 nbt, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.of(Either.left(keepProperties)), Optional.ofNullable(nbt), weight));
            return this;
        }

        public Builder add(class_2248 block, boolean keepProperties, class_2487 nbt, int weight) {
            return this.add(block.method_9564(), keepProperties, nbt, weight);
        }

        public Builder add(class_2680 state, boolean keepProperties, class_2487 nbt, int weight) {
            this.entries.add(new BlockConversionLoader.WeightedValue(state, Optional.of(Either.right((Object)keepProperties)), Optional.ofNullable(nbt), weight));
            return this;
        }
    }
}

