/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.entity;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.cca.GraceComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.entity.ModEntities;
import dev.enjarai.trickster.util.Trolling;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class LevitatingBlockEntity
extends class_1297 {
    protected static final class_2940<class_2338> BLOCK_POS = class_2945.method_12791(LevitatingBlockEntity.class, (class_2941)class_2943.field_13324);
    protected static final class_2940<Float> WEIGHT = class_2945.method_12791(LevitatingBlockEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<class_2487> BLOCK_ENTITY_DATA = class_2945.method_12791(LevitatingBlockEntity.class, (class_2941)class_2943.field_13318);
    protected static final class_2940<Boolean> SHOULD_REVERT_NOW = class_2945.method_12791(LevitatingBlockEntity.class, (class_2941)class_2943.field_13323);
    private class_2680 blockState = class_2246.field_10340.method_9564();
    public class_2586 cachedBlockEntity;
    public int onGroundTicks = 0;

    public LevitatingBlockEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BLOCK_POS, (Object)class_2338.field_10980);
        builder.method_56912(WEIGHT, (Object)Float.valueOf(1.0f));
        builder.method_56912(BLOCK_ENTITY_DATA, (Object)new class_2487());
        builder.method_56912(SHOULD_REVERT_NOW, (Object)false);
    }

    public void method_48850(List<class_2945.class_7834<?>> entries) {
        super.method_48850(entries);
        this.field_23807 = true;
    }

    protected void method_5749(class_2487 nbt) {
        this.blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("BlockState"));
        if (nbt.method_10573("BlockEntityData", 10)) {
            this.setBlockEntityData(nbt.method_10562("BlockEntityData").method_10553());
        } else {
            this.setBlockEntityData(new class_2487());
        }
        if (nbt.method_10573("weight", 5)) {
            this.setWeight(nbt.method_10583("weight"));
        }
        class_2512.method_10691((class_2487)nbt, (String)"fallingBlockPos").ifPresent(this::setFallingBlockPos);
        if (nbt.method_10573("shouldRevertNow", 1)) {
            this.setShouldRevertNow(nbt.method_10577("shouldRevertNow"));
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        if (!this.getBlockEntityData().method_33133()) {
            nbt.method_10566("BlockEntityData", (class_2520)this.getBlockEntityData());
        }
        nbt.method_10548("weight", this.getWeight());
        nbt.method_10566("fallingBlockPos", class_2512.method_10692((class_2338)this.getFallingBlockPos()));
        nbt.method_10556("shouldRevertNow", this.getShouldRevertNow());
    }

    public static LevitatingBlockEntity spawnFromBlock(class_1937 world, class_2338 pos, class_2680 state, float weight) {
        LevitatingBlockEntity fallingBlockEntity = new LevitatingBlockEntity(ModEntities.LEVITATING_BLOCK, world);
        fallingBlockEntity.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        fallingBlockEntity.field_23807 = true;
        fallingBlockEntity.method_18799(class_243.field_1353);
        fallingBlockEntity.field_6014 = fallingBlockEntity.method_23317();
        fallingBlockEntity.field_6036 = fallingBlockEntity.method_23318();
        fallingBlockEntity.field_5969 = fallingBlockEntity.method_23321();
        fallingBlockEntity.blockState = state.method_28498((class_2769)class_2741.field_12508) ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) : state;
        fallingBlockEntity.setFallingBlockPos(pos);
        class_2586 entity = world.method_8321(pos);
        if (entity != null) {
            fallingBlockEntity.setBlockEntityData(entity.method_38243((class_7225.class_7874)world.method_30349()));
            Trolling.clearBlockEntityForDeletion(world, entity);
        }
        fallingBlockEntity.setWeight(weight);
        world.method_8652(pos, state.method_26227().method_15759(), 3);
        world.method_8649((class_1297)fallingBlockEntity);
        return fallingBlockEntity;
    }

    public void method_5773() {
        if (this.blockState.method_26215()) {
            this.method_31472();
        } else {
            this.method_56990();
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_60698();
            if (this.method_37908().method_8608()) {
                if (this.method_24828() && this.method_18798().method_1027() > 0.09) {
                    for (int i = 0; i < 10; ++i) {
                        this.method_5839();
                    }
                    class_2338 blockPos = this.method_49788(this.method_23312());
                    class_2680 blockState = this.method_37908().method_8320(blockPos);
                    class_2498 blockSoundGroup = blockState.method_26231();
                    this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), blockSoundGroup.method_10594(), class_3419.field_15245, blockSoundGroup.method_10597(), blockSoundGroup.method_10599(), true);
                }
                this.onGroundTicks = this.method_24828() ? ++this.onGroundTicks : 0;
            }
            if (this.getWeight() != 1.0f && !((GraceComponent)ModEntityComponents.GRACE.get((Object)this)).isInGrace("weight")) {
                if (this.getWeight() < 0.99f) {
                    this.setWeight(this.getWeight() + 0.01f);
                } else {
                    this.setWeight(1.0f);
                }
            }
            this.tickCollisions();
            this.trySolidify();
            if (!this.method_37908().method_8608() && this.method_24515().method_10264() <= this.method_37908().method_31607() - 64) {
                this.method_31472();
            }
        }
    }

    protected void trySolidify() {
        if (this.getWeight() >= 1.0f && (this.method_24828() || this.getShouldRevertNow()) && this.method_18798().method_1027() < 0.04000000000000001) {
            class_2338 targetPos;
            class_2338 class_23382 = this.field_44784.isPresent() ? (this.method_31478() > ((class_2338)this.field_44784.get()).method_10264() ? ((class_2338)this.field_44784.get()).method_10084() : (class_2338)this.field_44784.get()) : (targetPos = class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, 0.49, 0.0)));
            if (this.method_37908().method_8320(targetPos).method_45474()) {
                if (this.getShouldRevertNow() || this.method_19538().method_1025(targetPos.method_61082()) < 0.0025000000000000005) {
                    if (!this.method_37908().method_8608()) {
                        class_2680 blockState;
                        boolean isWater = this.method_37908().method_8316(targetPos).method_39360((class_3611)class_3612.field_15910);
                        boolean isWaterLoggable = this.blockState.method_28498((class_2769)class_2741.field_12508);
                        class_2680 class_26802 = blockState = isWater && isWaterLoggable ? (class_2680)this.blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : this.blockState;
                        if (this.method_37908().method_8652(targetPos, blockState, 3)) {
                            class_2586 blockEntity;
                            ((class_3218)this.method_37908()).method_14178().field_17254.method_18702((class_1297)this, (class_2596)new class_2626(targetPos, this.method_37908().method_8320(targetPos)));
                            this.method_31472();
                            if (!this.getBlockEntityData().method_33133() && blockState.method_31709() && (blockEntity = this.method_37908().method_8321(targetPos)) != null) {
                                class_2487 nbtCompound = blockEntity.method_38244((class_7225.class_7874)this.method_37908().method_30349());
                                for (String string : this.getBlockEntityData().method_10541()) {
                                    nbtCompound.method_10566(string, this.getBlockEntityData().method_10580(string).method_10707());
                                }
                                try {
                                    blockEntity.method_58690(nbtCompound, (class_7225.class_7874)this.method_37908().method_30349());
                                }
                                catch (Exception var15) {
                                    Trickster.LOGGER.error("Failed to load block entity from levitating block", (Throwable)var15);
                                }
                                blockEntity.method_5431();
                            }
                        }
                    }
                } else {
                    class_243 offset = targetPos.method_61082().method_1020(this.method_19538());
                    double distance = offset.method_1033();
                    class_243 travelDistance = offset.method_1029().method_1021(Math.min(distance, 0.2));
                    this.method_33574(this.method_19538().method_1019(travelDistance));
                }
            }
        }
    }

    protected float method_23326() {
        if (this.method_24828()) {
            return super.method_23326() * 0.9f;
        }
        return super.method_23326();
    }

    public void tickCollisions() {
        class_243 nextPos;
        class_243 velocity = this.method_18798();
        class_243 currentPos = this.method_19538();
        class_3966 hit = this.getEntityCollision(currentPos, nextPos = currentPos.method_1019(velocity));
        if (hit != null) {
            hit.method_17782().method_5643(this.method_37908().method_48963().method_48798((class_1297)this), (float)hit.method_17782().method_18798().method_1019(velocity.method_22882()).method_1033() * this.blockState.method_26214((class_1922)this.method_37908(), this.getFallingBlockPos()));
            hit.method_17782().method_18799(hit.method_17782().method_18798().method_1019(velocity));
            this.method_18799(velocity.method_1021(0.2));
        }
    }

    protected boolean canHit(class_1297 entity) {
        return entity.method_49108();
    }

    @Nullable
    protected class_3966 getEntityCollision(class_243 currentPosition, class_243 nextPosition) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::canHit);
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, entityTrackerEntry, class_2248.method_9507((class_2680)this.blockState));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.blockState = class_2248.method_9531((int)packet.method_11166());
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e, f);
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    protected double method_7490() {
        return 0.04 * (double)this.getWeight();
    }

    public boolean method_5732() {
        return false;
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public void setFallingBlockPos(class_2338 pos) {
        this.field_6011.method_12778(BLOCK_POS, (Object)pos);
    }

    public class_2338 getFallingBlockPos() {
        return (class_2338)this.field_6011.method_12789(BLOCK_POS);
    }

    public void setWeight(float weight) {
        this.field_6011.method_12778(WEIGHT, (Object)Float.valueOf(weight));
    }

    public float getWeight() {
        return ((Float)this.field_6011.method_12789(WEIGHT)).floatValue();
    }

    public void setBlockEntityData(class_2487 compound) {
        this.field_6011.method_12778(BLOCK_ENTITY_DATA, (Object)compound);
    }

    public class_2487 getBlockEntityData() {
        return (class_2487)this.field_6011.method_12789(BLOCK_ENTITY_DATA);
    }

    public void setShouldRevertNow(boolean shouldRevertNow) {
        this.field_6011.method_12778(SHOULD_REVERT_NOW, (Object)shouldRevertNow);
    }

    public boolean getShouldRevertNow() {
        return (Boolean)this.field_6011.method_12789(SHOULD_REVERT_NOW);
    }
}

