/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.item;

import dev.enjarai.trickster.cca.MessageHandlerComponent;
import dev.enjarai.trickster.cca.ModGlobalComponents;
import dev.enjarai.trickster.cca.SharedManaComponent;
import dev.enjarai.trickster.item.ChannelItem;
import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.item.component.TickTrackerComponent;
import dev.enjarai.trickster.net.EchoGrabClipboardPacket;
import dev.enjarai.trickster.net.EchoSetClipboardPacket;
import dev.enjarai.trickster.net.ModNetworking;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.execution.executor.MessageListenerSpellExecutor;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.mana.InfiniteManaPool;
import dev.enjarai.trickster.spell.mana.ManaPool;
import dev.enjarai.trickster.spell.mana.SavingsManaPool;
import dev.enjarai.trickster.spell.mana.SharedManaPool;
import dev.enjarai.trickster.spell.mana.SimpleManaPool;
import dev.enjarai.trickster.spell.trick.Trick;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToIntFunction;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public abstract class KnotItem
extends class_1792 {
    public static ToIntFunction<class_1799> barStepFunction = i -> 0;
    private final float creationCost;

    public KnotItem(class_1792.class_1793 settings, float creationCost) {
        super(settings.method_7889(1));
        this.creationCost = creationCost;
    }

    public boolean method_31567(class_1799 stack) {
        return stack.method_57826(ModComponents.MANA);
    }

    public int method_31571(class_1799 stack) {
        return 0xBB99FF;
    }

    public int method_31569(class_1799 stack) {
        return barStepFunction.applyAsInt(stack);
    }

    public float getCreationCost() {
        return this.creationCost;
    }

    public class_1799 createStack(class_1937 world) {
        return this.method_7854();
    }

    public static class Command
    extends KnotItem {
        public Command() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(InfiniteManaPool.INSTANCE, 0.0f)), Float.MAX_VALUE);
        }
    }

    public static class Astral
    extends KnotItem {
        public Astral() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SavingsManaPool(1048576.0f, (float)Math.pow(2.0, -20.0)), 0.0f)), 524288.0f);
        }
    }

    public static class CrackedEcho
    extends KnotItem
    implements ChannelItem {
        public CrackedEcho() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SimpleManaPool(32768.0f), 0.16666667f)), Float.MAX_VALUE);
        }

        @Override
        public EvaluationResult messageListenBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, int timeout) throws BlunderException {
            UUID uuid = UUID.randomUUID();
            ModNetworking.CHANNEL.serverHandle((class_1657)ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(trickSource))).send((Record)new EchoGrabClipboardPacket(uuid));
            return new MessageListenerSpellExecutor(ctx.state(), timeout, Optional.of(new MessageHandlerComponent.Key.Channel(uuid)));
        }

        @Override
        public void messageSendBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, Fragment value) throws BlunderException {
            ModNetworking.CHANNEL.serverHandle((class_1657)ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(trickSource))).send((Record)new EchoSetClipboardPacket(value));
        }

        @Override
        public int getRange() {
            return 16;
        }
    }

    public static class Echo
    extends KnotItem
    implements ChannelItem {
        public Echo() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SimpleManaPool(32768.0f), 1.0f)), 65536.0f);
        }

        @Override
        public class_1799 createStack(class_1937 world) {
            class_1799 stack = this.method_7854();
            SimpleManaPool pool = new SimpleManaPool(32768.0f);
            UUID uuid = ((SharedManaComponent)ModGlobalComponents.SHARED_MANA.get((Object)world.method_8428())).allocate(pool);
            stack.method_57379(ModComponents.MANA, (Object)new ManaComponent(new SharedManaPool(uuid), 1.0f));
            stack.method_7933(1);
            return stack;
        }

        @Override
        public EvaluationResult messageListenBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, int timeout) throws BlunderException {
            ManaPool manaPool = ((ManaComponent)stack.method_57824(ModComponents.MANA)).pool();
            if (manaPool instanceof SharedManaPool) {
                SharedManaPool pool = (SharedManaPool)manaPool;
                return new MessageListenerSpellExecutor(ctx.state(), timeout, Optional.of(new MessageHandlerComponent.Key.Channel(pool.uuid())));
            }
            throw new ItemInvalidBlunder(trickSource);
        }

        @Override
        public void messageSendBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, Fragment value) throws BlunderException {
            ManaPool manaPool = ((ManaComponent)stack.method_57824(ModComponents.MANA)).pool();
            if (manaPool instanceof SharedManaPool) {
                SharedManaPool pool = (SharedManaPool)manaPool;
                ((MessageHandlerComponent)ModGlobalComponents.MESSAGE_HANDLER.get((Object)ctx.source().getWorld().method_14170())).send(new MessageHandlerComponent.Key.Channel(pool.uuid()), value);
            }
        }

        @Override
        public int getRange() {
            return 16;
        }
    }

    public static class Diamond
    extends KnotItem {
        public Diamond() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SimpleManaPool(16384.0f), 0.33333334f)), 8192.0f);
        }
    }

    public static class Emerald
    extends KnotItem {
        public Emerald() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SimpleManaPool(1024.0f), 0.083333336f)), 512.0f);
        }
    }

    public static class Quartz
    extends KnotItem
    implements ChannelItem {
        public Quartz() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(new SimpleManaPool(128.0f), 0.010416667f)).method_57349(ModComponents.TICK_CREATED, (Object)new TickTrackerComponent(0L)), 0.0f);
        }

        @Override
        public class_1799 createStack(class_1937 world) {
            class_1799 stack = this.method_7854();
            stack.method_57379(ModComponents.TICK_CREATED, (Object)new TickTrackerComponent(world.method_8510()));
            return stack;
        }

        @Override
        public EvaluationResult messageListenBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, int timeout) throws BlunderException {
            return new NumberFragment(((TickTrackerComponent)stack.method_57824(ModComponents.TICK_CREATED)).getTick((class_1937)ctx.source().getWorld()));
        }

        @Override
        public void messageSendBehavior(Trick<?> trickSource, SpellContext ctx, class_1799 stack, Fragment value) throws BlunderException {
            if (value instanceof NumberFragment) {
                NumberFragment number = (NumberFragment)value;
                stack.method_57379(ModComponents.TICK_CREATED, (Object)new TickTrackerComponent(((TickTrackerComponent)stack.method_57824(ModComponents.TICK_CREATED)).tick() - (long)number.asInt()));
            }
        }

        @Override
        public int getRange() {
            return 16;
        }
    }

    public static class Amethyst
    extends KnotItem {
        public Amethyst() {
            super(new class_1792.class_1793().method_57349(ModComponents.MANA, (Object)new ManaComponent(SimpleManaPool.getSingleUse(128.0f), 0.0f)), 0.0f);
        }
    }
}

