/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.item.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.item.component.SelectedSlotComponent;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.MapFragment;
import io.vavr.Function1;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8824;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public record FragmentComponent(Fragment value, Optional<class_2561> name, boolean immutable, boolean closed) {
    private static final Endec<FragmentComponent> OLD_ENDEC = StructEndecBuilder.of((StructField)SpellPart.ENDEC.fieldOf("spell", comp -> {
        throw new IllegalStateException("Serializing as a spell is no longer supported");
    }), (StructField)Endec.BOOLEAN.optionalFieldOf("immutable", FragmentComponent::immutable, (Object)false), (StructField)Endec.BOOLEAN.optionalFieldOf("closed", FragmentComponent::closed, (Object)false), (value, immutable, closed) -> new FragmentComponent((Fragment)value, Optional.empty(), (boolean)immutable, (boolean)closed));
    private static final Endec<FragmentComponent> NEW_ENDEC = StructEndecBuilder.of((StructField)Fragment.COMPACT_ENDEC.fieldOf("value", FragmentComponent::value), (StructField)EndecTomfoolery.safeOptionalOf(CodecUtils.toEndec((Codec)class_8824.field_46598)).fieldOf("name", FragmentComponent::name), (StructField)Endec.BOOLEAN.optionalFieldOf("immutable", FragmentComponent::immutable, (Object)false), (StructField)Endec.BOOLEAN.optionalFieldOf("closed", FragmentComponent::closed, (Object)false), FragmentComponent::new);
    public static final Endec<FragmentComponent> ENDEC = EndecTomfoolery.withAlternative(NEW_ENDEC, OLD_ENDEC);
    private static java.util.HashMap<class_1792, Function1<class_1799, class_1799>> customWriteBehaviors = new java.util.HashMap();
    private static java.util.HashMap<class_1792, Function1<class_1799, class_1799>> customResetBehaviors = new java.util.HashMap();

    public FragmentComponent(SpellPart spell) {
        this(spell, Optional.empty(), false, false);
    }

    public FragmentComponent(SpellPart spell, boolean immutable) {
        this(spell, Optional.empty(), immutable, false);
    }

    public FragmentComponent withClosed(Optional<class_2561> name) {
        return new FragmentComponent(this.value, name, this.immutable, true);
    }

    public static Optional<SpellPart> getSpellPart(class_1799 stack) {
        return FragmentComponent.getFragment(stack).flatMap(value -> {
            if (value instanceof SpellPart) {
                SpellPart spell = (SpellPart)value;
                return Optional.of(spell);
            }
            return Optional.empty();
        });
    }

    public static Optional<class_1799> write(class_1799 stack, Fragment fragment) {
        return FragmentComponent.write(stack, fragment, false, Optional.empty(), Optional.empty());
    }

    public static Optional<class_1799> write(class_1799 stack, Fragment fragment, boolean closed, Optional<class_3222> player, Optional<class_2561> name) {
        if (!FragmentComponent.setValue(stack, fragment, name, closed)) {
            return Optional.empty();
        }
        Function1<class_1799, class_1799> behavior = customWriteBehaviors.get(stack.method_7909());
        if (behavior != null) {
            stack = (class_1799)behavior.apply((Object)stack);
        }
        player.ifPresent(ModCriteria.INSCRIBE_SPELL::trigger);
        return Optional.of(stack);
    }

    public static Optional<class_1799> reset(class_1799 stack) {
        if (FragmentComponent.getReferencedStack(stack).isEmpty()) {
            return Optional.of(stack);
        }
        boolean successful = FragmentComponent.modifyReferencedStack(stack, s -> {
            FragmentComponent component = (FragmentComponent)s.method_57824(ModComponents.FRAGMENT);
            if (component == null) {
                return true;
            }
            if (component.immutable()) {
                return false;
            }
            FragmentComponent itemDefault = (FragmentComponent)s.method_7909().method_7854().method_57824(ModComponents.FRAGMENT);
            if (itemDefault != null) {
                s.method_57379(ModComponents.FRAGMENT, (Object)itemDefault);
            } else {
                s.method_57381(ModComponents.FRAGMENT);
            }
            return true;
        });
        if (!successful) {
            return Optional.empty();
        }
        Function1<class_1799, class_1799> behavior = customResetBehaviors.get(stack.method_7909());
        if (behavior != null) {
            stack = (class_1799)behavior.apply((Object)stack);
        }
        return Optional.of(stack);
    }

    public static Optional<Fragment> getFragment(class_1799 stack) {
        return FragmentComponent.getReferencedStack(stack).filter(stack2 -> stack2.method_57826(ModComponents.FRAGMENT)).map(stack2 -> (FragmentComponent)stack2.method_57824(ModComponents.FRAGMENT)).filter(component -> !component.closed()).map(FragmentComponent::value);
    }

    public static boolean setValue(class_1799 stack, Fragment value, Optional<class_2561> name, boolean closed) {
        return FragmentComponent.modifyReferencedStack(stack, stack2 -> {
            if (stack2.method_57826(ModComponents.FRAGMENT) && ((FragmentComponent)stack2.method_57824(ModComponents.FRAGMENT)).immutable()) {
                return false;
            }
            stack2.method_57379(ModComponents.FRAGMENT, (Object)new FragmentComponent(value, name, false, closed));
            return true;
        });
    }

    public static Optional<class_1799> getReferencedStack(class_1799 stack) {
        Optional<Object> stackOptional = Optional.of(stack);
        if (stack.method_31573(ModItems.HOLDABLE_HAT) && stack.method_57826(class_9334.field_49622) && stack.method_57826(ModComponents.SELECTED_SLOT)) {
            stackOptional = ((class_9288)stack.method_57824(class_9334.field_49622)).method_57489().skip(((SelectedSlotComponent)stack.method_57824(ModComponents.SELECTED_SLOT)).slot()).findFirst();
        }
        return stackOptional;
    }

    public static boolean modifyReferencedStack(class_1799 stack, Function<class_1799, Boolean> modifier) {
        if (stack.method_31573(ModItems.HOLDABLE_HAT) && stack.method_57826(class_9334.field_49622) && stack.method_57826(ModComponents.SELECTED_SLOT)) {
            ArrayList stacks = ((class_9288)stack.method_57824(class_9334.field_49622)).method_57489().collect(Collectors.toCollection(ArrayList::new));
            class_1799 stack2 = (class_1799)stacks.get(((SelectedSlotComponent)stack.method_57824(ModComponents.SELECTED_SLOT)).slot());
            boolean modified = modifier.apply(stack2);
            if (modified) {
                stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)stacks));
            }
            return modified;
        }
        return modifier.apply(stack);
    }

    public static <T extends Fragment> Optional<T> getValue(class_1799 stack, Class<T> clazz) {
        return Optional.ofNullable(stack).filter(stack2 -> stack2.method_57826(ModComponents.FRAGMENT)).map(stack2 -> (FragmentComponent)stack2.method_57824(ModComponents.FRAGMENT)).map(FragmentComponent::value).flatMap(value -> {
            if (value.getClass() == clazz) {
                return Optional.of(value);
            }
            return Optional.empty();
        });
    }

    public static Optional<HashMap<Pattern, SpellPart>> getMap(class_1799 stack) {
        return FragmentComponent.getValue(stack, MapFragment.class).map(MapFragment::getMacroMap);
    }

    public static Optional<HashMap<Pattern, SpellPart>> getUserMergedMap(class_1657 user, String type) {
        AccessoriesCapability capability = user.accessoriesCapability();
        if (capability == null) {
            return Optional.empty();
        }
        AccessoriesContainer ringContainer = (AccessoriesContainer)capability.getContainers().get(type);
        if (ringContainer == null) {
            return Optional.empty();
        }
        HashMap result = HashMap.empty();
        for (Pair pair : ringContainer.getAccessories()) {
            result = result.merge((Map)FragmentComponent.getMap((class_1799)pair.getSecond()).orElse((HashMap<Pattern, SpellPart>)HashMap.empty()));
        }
        return Optional.of(result);
    }

    public static HashMap<Pattern, SpellPart> getUserMergedMap(class_1657 user, String type, Supplier<HashMap<Pattern, SpellPart>> otherwise) {
        return FragmentComponent.getUserMergedMap(user, type).orElseGet(otherwise);
    }

    public static void registerWriteConversion(class_1792 type, Function1<class_1799, class_1799> onWrite) {
        Function1<class_1799, class_1799> old = customWriteBehaviors.put(type, onWrite);
        if (old != null) {
            Trickster.LOGGER.warn("Fragment write conversion for \"{}\" has been overriden", (Object)type.method_7848().getString());
        }
    }

    public static void registerResetConversion(class_1792 type, Function1<class_1799, class_1799> onReset) {
        Function1<class_1799, class_1799> old = customResetBehaviors.put(type, onReset);
        if (old != null) {
            Trickster.LOGGER.warn("Fragment reset conversion for \"{}\" has been overriden", (Object)type.method_7848().getString());
        }
    }
}

