/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.render.fleck;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.fleck.LineFleck;
import dev.enjarai.trickster.render.fleck.FleckRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class LineFleckRenderer
implements FleckRenderer<LineFleck> {
    static final class_2960 LINE_TEXTURE = Trickster.id("textures/flecks/line.png");
    private static final float LINE_SEGMENT_WIDTH = 0.1f;
    private static final float LINE_SEGMENT_LENGTH = (float)Math.sqrt(1.0);
    private static final int LINE_ALPHA = 180;

    @Override
    public void render(LineFleck fleck, LineFleck lastFleck, WorldRenderContext context, class_638 world, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int color) {
        Vector3f pos1 = fleck.pos().get(new Vector3f());
        Vector3f pos2 = fleck.pos2().get(new Vector3f());
        if (lastFleck != null) {
            Vector3fc oldPos1 = lastFleck.pos();
            Vector3fc oldPos2 = lastFleck.pos2();
            oldPos1.lerp((Vector3fc)pos1, tickDelta, pos1);
            oldPos2.lerp((Vector3fc)pos2, tickDelta, pos2);
        }
        Vector3f offset = pos2.sub((Vector3fc)pos1, new Vector3f());
        Vector3f step = offset.normalize().mul(LINE_SEGMENT_LENGTH);
        Vector3f prev = pos1.get(new Vector3f());
        Vector3f cur = pos1.add((Vector3fc)step, new Vector3f());
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)LINE_TEXTURE));
        int argb = class_5253.class_5254.method_58144((int)180, (int)color);
        Vector3f camPos = context.camera().method_19326().method_46409();
        while (pos1.distance((Vector3fc)pos2) >= pos1.distance((Vector3fc)cur)) {
            LineFleckRenderer.drawSegment((Vector3fc)prev, (Vector3fc)cur, 0.1f, matrices, buffer, argb, 0xF000F0, camPos, 1.0f);
            prev.add((Vector3fc)step);
            cur.add((Vector3fc)step);
        }
        LineFleckRenderer.drawSegment((Vector3fc)prev, (Vector3fc)pos2, 0.1f, matrices, buffer, argb, 0xF000F0, camPos, prev.distance((Vector3fc)pos2) / LINE_SEGMENT_LENGTH);
    }

    private static void drawSegment(Vector3fc start, Vector3fc end, float width, class_4587 matrices, class_4588 buffer, int argb, int light, Vector3f camPos, float uvfactor) {
        matrices.method_22903();
        matrices.method_46416(-camPos.x, -camPos.y, -camPos.z);
        matrices.method_34425(new Matrix4f().billboardCylindrical(start, (Vector3fc)camPos, (Vector3fc)start.sub(end, new Vector3f()).normalize()));
        class_4587.class_4665 top = matrices.method_23760();
        Matrix4f positionMatrix = top.method_23761();
        float distance = start.distance(end);
        float cornerOffset = 0.1875f;
        Vector2f topLeftUV = new Vector2f(0.0f, cornerOffset).lerp((Vector2fc)new Vector2f(1.0f - cornerOffset, 1.0f), uvfactor);
        Vector2f topRightUV = new Vector2f(cornerOffset, 0.0f).lerp((Vector2fc)new Vector2f(1.0f, 1.0f - cornerOffset), uvfactor);
        buffer.method_22918(positionMatrix, width, 0.0f, 0.0f).method_39415(argb).method_22913(cornerOffset, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(top, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, width, -distance, 0.0f).method_39415(argb).method_22913(topRightUV.x, topRightUV.y).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(top, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, -width, -distance, 0.0f).method_39415(argb).method_22913(topLeftUV.x, topLeftUV.y).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(top, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, -width, 0.0f, 0.0f).method_39415(argb).method_22913(0.0f, cornerOffset).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(top, 0.0f, 1.0f, 0.0f);
        matrices.method_22909();
    }
}

