/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.screen;

import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.screen.ScrollAndQuillScreenHandler;
import dev.enjarai.trickster.screen.SpellPartWidget;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellPart;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import org.joml.Vector2d;

@Environment(value=EnvType.CLIENT)
public class ScrollAndQuillScreen
extends class_437
implements class_3936<ScrollAndQuillScreenHandler> {
    private static final ArrayList<PositionMemory> storedPositions = new ArrayList(5);
    protected final ScrollAndQuillScreenHandler handler;
    public SpellPartWidget partWidget;
    private boolean hasLoaded = false;
    static final double ZOOM_SPEED = 1.0;
    private double inputZ = 0.0;

    public ScrollAndQuillScreen(ScrollAndQuillScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super(title);
        this.handler = handler;
    }

    protected void method_25426() {
        super.method_25426();
        this.partWidget = new SpellPartWidget((SpellPart)this.handler.spell.get(), (double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 64.0, this.handler, true);
        this.handler.replacerCallback = frag -> this.partWidget.replaceCallback((Fragment)frag);
        this.handler.updateDrawingPartCallback = spell -> this.partWidget.updateDrawingPartCallback((Optional<SpellPart>)spell);
        this.method_37063((class_364)this.partWidget);
        this.handler.spell.observe(spell -> {
            int spellHash = spell.hashCode();
            if (!this.hasLoaded) {
                for (PositionMemory position : storedPositions) {
                    if (position.spellHash != spellHash) continue;
                    this.partWidget.load(position);
                    break;
                }
            }
            this.partWidget.setSpell((SpellPart)spell);
            this.hasLoaded = true;
        });
        this.handler.isMutable.observe(mutable -> this.partWidget.setMutable((boolean)mutable));
    }

    public void method_25419() {
        if (this.partWidget.cancelDrawing()) {
            return;
        }
        PositionMemory saved = this.partWidget.saveAndClose();
        storedPositions.removeIf(position -> position.spellHash == saved.spellHash);
        storedPositions.add(saved);
        if (storedPositions.size() >= 5) {
            storedPositions.removeFirst();
        }
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.partWidget.method_16014(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, 0, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.method_25398(true);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25397()) {
            this.method_25398(false);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.inputZ != 0.0) {
            this.partWidget.method_25401(mouseX, mouseY, 0.0, this.inputZ * 1.0 * (double)delta);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        if (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode)) {
            this.inputZ = 1.0;
            return true;
        }
        if (this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode)) {
            this.inputZ = -1.0;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode)) {
            this.inputZ = 0.0;
            return true;
        }
        if (this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode)) {
            this.inputZ = 0.0;
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public ScrollAndQuillScreenHandler getScreenHandler() {
        return this.handler;
    }

    protected void method_57734(float delta) {
        if (!this.field_22787.field_1724.method_6079().method_31574((class_1792)ModItems.TOME_OF_TOMFOOLERY)) {
            super.method_57734(delta);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record PositionMemory(int spellHash, Vector2d position, double radius, SpellPart rootSpellPart, SpellPart spellPart, ArrayList<SpellPart> parents, ArrayList<Double> angleOffsets) {
    }
}

