/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.screen;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.ModSounds;
import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.revision.RevisionContext;
import dev.enjarai.trickster.screen.ModScreenHandlers;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.NaNBlunder;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.execution.source.PlayerSpellSource;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import io.vavr.collection.HashMap;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.client.screens.SyncedProperty;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ScrollAndQuillScreenHandler
extends class_1703
implements RevisionContext {
    private final class_1799 scrollStack;
    private final class_1799 otherHandStack;
    public final SyncedProperty<SpellPart> spell = this.createProperty(SpellPart.class, (Endec)SpellPart.ENDEC, new SpellPart());
    public final SyncedProperty<SpellPart> otherHandSpell = this.createProperty(SpellPart.class, (Endec)SpellPart.ENDEC, new SpellPart());
    public final SyncedProperty<Boolean> isMutable = this.createProperty(Boolean.class, true);
    public final SyncedProperty<HashMap<Pattern, SpellPart>> macros = this.createProperty(null, EndecTomfoolery.hamt(Pattern.ENDEC, SpellPart.ENDEC), HashMap.empty());
    public Consumer<Fragment> replacerCallback;
    public Consumer<Optional<SpellPart>> updateDrawingPartCallback;
    public final class_1304 slot;
    public final boolean greedyEvaluation;

    public ScrollAndQuillScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, null, null, null, null, false, true);
    }

    public ScrollAndQuillScreenHandler(int syncId, class_1661 playerInventory, class_1799 scrollStack, class_1799 otherHandStack, class_1304 slot, HashMap<Pattern, SpellPart> macros, boolean greedyEvaluation, boolean isMutable) {
        super(ModScreenHandlers.SCROLL_AND_QUILL, syncId);
        this.scrollStack = scrollStack;
        this.otherHandStack = otherHandStack;
        this.slot = slot;
        this.greedyEvaluation = greedyEvaluation;
        if (macros != null) {
            this.macros.set(macros);
        }
        if (scrollStack != null) {
            FragmentComponent.getSpellPart(scrollStack).ifPresent(arg_0 -> this.spell.set(arg_0));
        }
        if (otherHandStack != null) {
            FragmentComponent.getSpellPart(otherHandStack).ifPresent(arg_0 -> this.otherHandSpell.set(arg_0));
        }
        this.isMutable.set((Object)isMutable);
        this.addServerboundMessage(SpellMessage.class, SpellMessage.ENDEC, msg -> this.updateSpell(msg.spell()));
        this.addServerboundMessage(OtherHandSpellMessage.class, OtherHandSpellMessage.ENDEC, msg -> this.updateOffHandSpell(msg.spell()));
        this.addServerboundMessage(UpdateSpellWithSpellMessage.class, UpdateSpellWithSpellMessage.ENDEC, msg -> this.updateSpellWithSpell(msg.drawingPart, msg.spell));
        this.addServerboundMessage(ExecuteOffhand.class, msg -> this.executeOffhand());
        this.addClientboundMessage(UpdateDrawingPartMessage.class, UpdateDrawingPartMessage.ENDEC, msg -> {
            if (this.updateDrawingPartCallback != null) {
                this.updateDrawingPartCallback.accept(msg.spell);
            }
        });
        this.addClientboundMessage(Replace.class, Replace.ENDEC, msg -> {
            if (this.replacerCallback != null) {
                this.replacerCallback.accept(msg.fragment());
            }
        });
    }

    @Override
    public void updateSpellWithSpell(SpellPart drawingPart, SpellPart spell) {
        if (((Boolean)this.isMutable.get()).booleanValue()) {
            if (this.scrollStack != null) {
                MinecraftServer server = this.player().method_5682();
                if (server != null) {
                    server.execute(() -> {
                        ExecutionState executionState = new ExecutionState(List.of(drawingPart));
                        Fragment result = null;
                        try {
                            result = new DefaultSpellExecutor(spell, executionState).singleTickRun(new PlayerSpellSource((class_3222)this.player()));
                        }
                        catch (BlunderException e) {
                            if (e instanceof NaNBlunder) {
                                ModCriteria.NAN_NUMBER.trigger((class_3222)this.player());
                            }
                            this.player().method_43496((class_2561)e.createMessage().method_27693(" (").method_10852(executionState.formatStackTrace()).method_27693(")"));
                        }
                        catch (Exception e) {
                            this.player().method_43496((class_2561)class_2561.method_43470((String)("Uncaught exception in spell: " + e.getMessage())).method_27693(" (").method_10852(executionState.formatStackTrace()).method_27693(")"));
                        }
                        if (result instanceof SpellPart) {
                            SpellPart spellResult = (SpellPart)result;
                            this.sendMessage(new UpdateDrawingPartMessage(Optional.of(spellResult)));
                            ModCriteria.USE_MACRO.trigger((class_3222)this.player());
                        } else if (result == null) {
                            this.sendMessage(new UpdateDrawingPartMessage(Optional.empty()));
                        } else {
                            this.player().method_43496((class_2561)class_2561.method_43470((String)"Macro expansion failed: Macro must return a ").method_10852((class_2561)FragmentType.SPELL_PART.getName().method_27693(" but it returned ").method_10852(result.asFormattedText())));
                            this.sendMessage(new UpdateDrawingPartMessage(Optional.empty()));
                        }
                    });
                }
            } else {
                this.sendMessage(new UpdateSpellWithSpellMessage(drawingPart, spell));
            }
        }
    }

    @Override
    public void updateSpell(SpellPart spell) {
        if (((Boolean)this.isMutable.get()).booleanValue()) {
            if (this.scrollStack != null) {
                MinecraftServer server = this.player().method_5682();
                if (server != null) {
                    server.execute(() -> {
                        if (this.greedyEvaluation) {
                            ExecutionState executionState = new ExecutionState(List.of());
                            try {
                                spell.destructiveRun(new SpellContext(executionState, new PlayerSpellSource((class_3222)this.player()), new TickData()));
                                this.spell.set((Object)spell);
                            }
                            catch (BlunderException e) {
                                if (e instanceof NaNBlunder) {
                                    ModCriteria.NAN_NUMBER.trigger((class_3222)this.player());
                                }
                                this.player().method_43496((class_2561)e.createMessage().method_27693(" (").method_10852(executionState.formatStackTrace()).method_27693(")"));
                            }
                            catch (Exception e) {
                                this.player().method_43496((class_2561)class_2561.method_43470((String)("Uncaught exception in spell: " + e.getMessage())).method_27693(" (").method_10852(executionState.formatStackTrace()).method_27693(")"));
                            }
                            ((class_3222)this.player()).method_51469().method_43129(null, (class_1297)this.player(), ModSounds.CAST, class_3419.field_15248, 1.0f, ModSounds.randomPitch(0.8f, 0.2f));
                        } else {
                            this.spell.set((Object)spell.applyEphemeral());
                        }
                        FragmentComponent.setValue(this.scrollStack, spell, Optional.empty(), false);
                    });
                }
            } else {
                this.sendMessage(new SpellMessage(spell));
            }
        }
    }

    @Override
    public void updateOffHandSpell(SpellPart spell) {
        if (this.isOffhand()) {
            this.updateSpell(spell);
        } else if (((Boolean)this.isMutable.get()).booleanValue()) {
            if (this.otherHandStack != null) {
                MinecraftServer server;
                if (!this.otherHandStack.method_7960() && (server = this.player().method_5682()) != null) {
                    server.execute(() -> {
                        Optional<class_1799> updated = FragmentComponent.write(this.otherHandStack, spell);
                        this.player().method_6122(class_1268.field_5810, updated.orElse(this.otherHandStack));
                        this.otherHandSpell.set((Object)spell);
                    });
                }
            } else {
                this.sendMessage(new OtherHandSpellMessage(spell));
            }
        }
    }

    @Override
    public SpellPart getOtherHandSpell() {
        return (SpellPart)this.otherHandSpell.get();
    }

    @Override
    public HashMap<Pattern, SpellPart> getMacros() {
        return (HashMap)this.macros.get();
    }

    public boolean isOffhand() {
        return this.slot == class_1304.field_6171;
    }

    @Override
    public void executeOffhand() {
        MinecraftServer server = this.player().method_5682();
        if (server != null) {
            server.execute(() -> {
                if (this.player().method_31548().method_7382(ModItems.CAN_EVALUATE_DYNAMICALLY)) {
                    DefaultSpellExecutor spell = new DefaultSpellExecutor((SpellPart)this.otherHandSpell.get(), List.of());
                    Fragment result = VoidFragment.INSTANCE;
                    try {
                        result = spell.singleTickRun(new PlayerSpellSource((class_3222)this.player()));
                    }
                    catch (BlunderException blunder) {
                        if (blunder instanceof NaNBlunder) {
                            ModCriteria.NAN_NUMBER.trigger((class_3222)this.player());
                        }
                        this.player().method_43496((class_2561)blunder.createMessage().method_27693(" (").method_10852(spell.getDeepestState().formatStackTrace()).method_27693(")"));
                    }
                    catch (Exception e) {
                        this.player().method_43496((class_2561)class_2561.method_43470((String)("Uncaught exception in spell: " + e.getMessage())).method_27693(" (").method_10852(spell.getDeepestState().formatStackTrace()).method_27693(")"));
                    }
                    this.sendMessage(new Replace(result));
                    ((class_3222)this.player()).method_51469().method_43129(null, (class_1297)this.player(), ModSounds.CAST, class_3419.field_15248, 1.0f, ModSounds.randomPitch(0.8f, 0.2f));
                }
            });
        } else {
            this.sendMessage(new ExecuteOffhand());
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public record SpellMessage(SpellPart spell) {
        public static final Endec<SpellMessage> ENDEC = SpellPart.ENDEC.xmap(SpellMessage::new, SpellMessage::spell);
    }

    public record OtherHandSpellMessage(SpellPart spell) {
        public static final Endec<OtherHandSpellMessage> ENDEC = SpellPart.ENDEC.xmap(OtherHandSpellMessage::new, OtherHandSpellMessage::spell);
    }

    public record UpdateSpellWithSpellMessage(SpellPart drawingPart, SpellPart spell) {
        public static final Endec<UpdateSpellWithSpellMessage> ENDEC = StructEndecBuilder.of((StructField)SpellPart.ENDEC.fieldOf("drawing_part", UpdateSpellWithSpellMessage::drawingPart), (StructField)SpellPart.ENDEC.fieldOf("spell", UpdateSpellWithSpellMessage::spell), UpdateSpellWithSpellMessage::new);
    }

    public record ExecuteOffhand() {
    }

    private record UpdateDrawingPartMessage(Optional<SpellPart> spell) {
        public static final Endec<UpdateDrawingPartMessage> ENDEC = SpellPart.ENDEC.optionalOf().xmap(UpdateDrawingPartMessage::new, UpdateDrawingPartMessage::spell);
    }

    public record Replace(Fragment fragment) {
        public static final Endec<Replace> ENDEC = Fragment.ENDEC.xmap(Replace::new, Replace::fragment);
    }
}

