/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.screen;

import dev.enjarai.trickster.ModSounds;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.render.SpellCircleRenderer;
import dev.enjarai.trickster.revision.Revision;
import dev.enjarai.trickster.revision.RevisionContext;
import dev.enjarai.trickster.revision.Revisions;
import dev.enjarai.trickster.screen.ScrollAndQuillScreen;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4597;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public class SpellPartWidget
extends class_362
implements class_4068,
class_6379 {
    public static final double PRECISION_OFFSET = Math.pow(2.0, 50.0);
    public static final double ZOOM_SPEED = 0.1;
    static final Byte MIDDLE_DOT = 4;
    static final Byte DOT_COUNT = 9;
    static final Byte[] RING_ORDER = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)5, (byte)8, (byte)7, (byte)6, (byte)3};
    static final Byte[] RING_INDICES = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)7, (byte)0, (byte)3, (byte)6, (byte)5, (byte)4};
    private SpellPart rootSpellPart;
    private SpellPart spellPart;
    private final Stack<SpellPart> parents = new Stack();
    private final Stack<Double> angleOffsets = new Stack();
    public Vector2d position;
    public double radius;
    public double windowHeight = 600.0;
    private double amountDragged;
    private boolean isMutable = true;
    @Nullable
    private SpellPart toBeReplaced;
    private final Vector2d originalPosition;
    private final RevisionContext revisionContext;
    private SpellPart drawingPart;
    private Fragment oldGlyph;
    private List<Byte> drawingPattern;
    public final SpellCircleRenderer renderer;

    public SpellPartWidget(SpellPart spellPart, double x, double y, double radius, RevisionContext revisionContext, boolean animated) {
        this.rootSpellPart = spellPart;
        this.spellPart = spellPart;
        this.originalPosition = new Vector2d(SpellPartWidget.toScaledSpace(x), SpellPartWidget.toScaledSpace(y));
        this.position = new Vector2d((Vector2dc)this.originalPosition);
        this.radius = SpellPartWidget.toScaledSpace(radius);
        this.revisionContext = revisionContext;
        this.renderer = new SpellCircleRenderer(() -> this.drawingPart, () -> this.drawingPattern, PRECISION_OFFSET, animated);
        this.angleOffsets.push(0.0);
    }

    public List<? extends class_364> method_25396() {
        return List.of();
    }

    public void setSpell(SpellPart spellPart) {
        Stack<SpellPart> newParents = new Stack<SpellPart>();
        Stack<Double> newAngleOffsets = new Stack<Double>();
        newParents.push(spellPart);
        ArrayList<SpellPart> currentParents = new ArrayList<SpellPart>(this.parents);
        ArrayList<Double> currentAngleOffsets = new ArrayList<Double>(this.angleOffsets);
        newAngleOffsets.push(currentAngleOffsets.removeFirst());
        for (int i = currentParents.size() - 1; i >= 0; --i) {
            SpellPart spellGlyph;
            SpellPart currentParent = currentParents.removeFirst();
            SpellPart currentChild = !currentParents.isEmpty() ? currentParents.getFirst() : this.spellPart;
            Fragment fragment = currentParent.glyph;
            if (fragment instanceof SpellPart && (spellGlyph = (SpellPart)fragment) == currentChild) {
                Fragment fragment2 = ((SpellPart)newParents.peek()).glyph;
                if (!(fragment2 instanceof SpellPart)) break;
                SpellPart newSpellGlyph = (SpellPart)fragment2;
                newParents.push(newSpellGlyph);
            } else {
                boolean failed = true;
                int i2 = 0;
                for (SpellPart child : currentParent.subParts) {
                    if (child == currentChild) {
                        if (((SpellPart)newParents.peek()).subParts.size() <= i2) break;
                        newParents.push(((SpellPart)newParents.peek()).subParts.get(i2));
                        failed = false;
                        break;
                    }
                    ++i2;
                }
                if (failed) {
                    this.position = new Vector2d((Vector2dc)this.originalPosition);
                    break;
                }
            }
            newAngleOffsets.push(currentAngleOffsets.removeFirst());
        }
        this.rootSpellPart = spellPart;
        this.spellPart = (SpellPart)newParents.pop();
        this.parents.clear();
        this.angleOffsets.clear();
        this.parents.addAll(new ArrayList(newParents));
        this.angleOffsets.addAll(new ArrayList(newAngleOffsets));
    }

    public boolean cancelDrawing() {
        if (this.drawingPart != null) {
            this.drawingPart.glyph = this.oldGlyph;
            this.drawingPart = null;
            this.drawingPattern = null;
            this.revisionContext.updateSpell(this.rootSpellPart);
            class_310.method_1551().field_1724.method_17356(ModSounds.COMPLETE, class_3419.field_15250, 1.0f, 0.6f);
            return true;
        }
        return false;
    }

    public ScrollAndQuillScreen.PositionMemory saveAndClose() {
        return new ScrollAndQuillScreen.PositionMemory(this.rootSpellPart.hashCode(), this.position, this.radius, this.rootSpellPart, this.spellPart, new ArrayList<SpellPart>(this.parents), new ArrayList<Double>(this.angleOffsets));
    }

    public void load(ScrollAndQuillScreen.PositionMemory memory) {
        this.position = memory.position();
        this.radius = memory.radius();
        this.rootSpellPart = memory.rootSpellPart();
        this.spellPart = memory.spellPart();
        this.parents.clear();
        this.angleOffsets.clear();
        this.parents.addAll(memory.parents());
        this.angleOffsets.addAll(memory.angleOffsets());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isMutable) {
            this.renderer.setMousePosition(mouseX, mouseY);
        }
        this.windowHeight = context.method_51443();
        this.renderer.renderPart(context.method_51448(), (class_4597)context.method_51450(), this.spellPart, this.position.x, this.position.y, this.radius, this.angleOffsets.peek(), delta, radius -> Float.valueOf((float)Math.clamp(1.0 / ((double)radius.floatValue() / this.windowHeight * 3.0), 0.0, 0.8)), new class_243(-1.0, 0.0, 0.0));
        context.method_51452();
    }

    public static boolean isCircleClickable(double radius) {
        return radius >= 16.0 && radius <= 256.0;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void setMutable(boolean mutable) {
        this.isMutable = mutable;
        if (!mutable) {
            this.renderer.setMousePosition(Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        double minZoom = SpellPartWidget.toScaledSpace(this.windowHeight * 0.1);
        Vector2d scaledMouse = SpellPartWidget.toScaledSpace(new Vector2d(mouseX, mouseY));
        this.radius = Math.max(this.radius + verticalAmount * this.radius * 0.1, minZoom);
        if (this.radius > minZoom) {
            this.position.add((Vector2dc)new Vector2d((Vector2dc)this.position).sub((Vector2dc)scaledMouse).mul(verticalAmount * 0.1));
        }
        float subRadius = SpellPartWidget.toLocalSpace(this.spellPart.subRadius(this.radius));
        if (verticalAmount > 0.0) {
            if ((double)subRadius > this.windowHeight && (this.spellPart.glyph instanceof SpellPart || this.spellPart.partCount() > 0)) {
                this.pushNewRoot(scaledMouse);
            }
        } else if ((double)subRadius < this.windowHeight / 2.0 && !this.parents.empty()) {
            this.popOldRoot();
        }
        return true;
    }

    private void popOldRoot() {
        SpellPart inner;
        SpellPart result = this.parents.pop();
        this.angleOffsets.pop();
        int partCount = result.partCount();
        double parentRadius = this.radius * 3.0;
        int i = 0;
        Fragment fragment = result.glyph;
        if (!(fragment instanceof SpellPart) || (inner = (SpellPart)fragment) != this.spellPart) {
            parentRadius = Math.max(this.radius * 2.0, this.radius * (double)((partCount + 1) / 2));
            for (SpellPart child : result.subParts) {
                if (child == this.spellPart) {
                    Vector2d subPos = result.subPosition(i, parentRadius, this.angleOffsets.peek());
                    this.position.sub((Vector2dc)subPos);
                    break;
                }
                ++i;
            }
        }
        this.radius = parentRadius;
        this.spellPart = result;
    }

    private void pushNewRoot(Vector2d scaledMouse) {
        double angle = this.angleOffsets.peek();
        int closestIndex = SpellPartWidget.closestIndex(this.spellPart, this.position, scaledMouse, this.radius, angle);
        if (closestIndex == -1) {
            this.radius /= 3.0;
            this.angleOffsets.push(angle);
            this.parents.push(this.spellPart);
            Fragment fragment = this.spellPart.glyph;
            if (fragment instanceof SpellPart) {
                SpellPart inner;
                this.spellPart = inner = (SpellPart)fragment;
            }
        } else {
            this.position.add((Vector2dc)this.spellPart.subPosition(closestIndex, this.radius, angle));
            this.radius = this.spellPart.subRadius(this.radius);
            this.angleOffsets.push(this.spellPart.subAngle(closestIndex, angle));
            this.parents.push(this.spellPart);
            this.spellPart = this.spellPart.subParts.get(closestIndex);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (!this.isDrawing()) {
            this.position.add((Vector2dc)SpellPartWidget.toScaledSpace(new Vector2d(deltaX, deltaY)));
            this.amountDragged += Math.abs(deltaX) + Math.abs(deltaY);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMutable || this.isDrawing()) {
            if (Trickster.CONFIG.dragDrawing() && button == 0 && !this.isDrawing()) {
                this.propagateMouseEvent(mouseX, mouseY, this::selectPattern);
            } else {
                this.propagateMouseEvent(mouseX, mouseY, (part, pos, rad, mouse) -> true);
            }
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isMutable || this.isDrawing()) {
            double dragged = this.amountDragged;
            this.amountDragged = 0.0;
            if (dragged > 5.0) {
                return false;
            }
            if (!Trickster.CONFIG.dragDrawing() && button == 0 && !this.isDrawing() && this.propagateMouseEvent(mouseX, mouseY, this::selectPattern)) {
                return true;
            }
            if (this.drawingPart != null) {
                this.stopDrawing();
                return true;
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.isDrawing()) {
            this.propagateMouseEvent(mouseX, mouseY, this::selectPattern);
        }
        super.method_16014(mouseX, mouseY);
    }

    private static int closestIndex(SpellPart part, Vector2d position, Vector2d mouse, double radius, double angleOffset) {
        int closest = -1;
        double closestDistanceSquared = Double.MAX_VALUE;
        if (part.glyph instanceof SpellPart) {
            closestDistanceSquared = position.distanceSquared((Vector2dc)mouse);
        }
        for (int i = 0; i < part.partCount(); ++i) {
            Vector2d subPos = part.subPosition(i, radius, angleOffset).add((Vector2dc)position);
            double distanceSquared = subPos.distanceSquared((Vector2dc)mouse);
            if (!(distanceSquared < closestDistanceSquared)) continue;
            closest = i;
            closestDistanceSquared = distanceSquared;
        }
        return closest;
    }

    private static boolean areAdjacent(byte a, byte b) {
        if (a == MIDDLE_DOT || b == MIDDLE_DOT) {
            return false;
        }
        Byte i = RING_INDICES[a];
        return b == RING_ORDER[(i + 1) % 8] || b == RING_ORDER[i == 0 ? 7 : (i - 1) % 8];
    }

    private boolean hasLine(byte a, byte b) {
        for (int i = 0; i < this.drawingPattern.size(); ++i) {
            if (i >= this.drawingPattern.size() - 1) continue;
            Byte prev = this.drawingPattern.get(i);
            Byte next = this.drawingPattern.get(i + 1);
            if ((prev != a || next != b) && (prev != b || next != a)) continue;
            return true;
        }
        return false;
    }

    private HashMap<Byte, List<Byte>> possibleMoves() {
        HashMap<Byte, List<Byte>> moves = new HashMap<Byte, List<Byte>>();
        if (this.drawingPattern.isEmpty()) {
            for (byte i = 0; i < DOT_COUNT; i = (byte)(i + 1)) {
                ArrayList<Byte> move = new ArrayList<Byte>();
                move.add(i);
                moves.put(i, move);
            }
        } else {
            Byte last = this.drawingPattern.getLast();
            for (byte i = 0; i < DOT_COUNT; i = (byte)(i + 1)) {
                ArrayList<Byte> move;
                if (i == last) continue;
                if (!this.hasLine(i, last)) {
                    move = new ArrayList<Byte>(this.drawingPattern);
                    if (i == 8 - last) {
                        if (this.hasLine(i, MIDDLE_DOT) || this.hasLine(last, MIDDLE_DOT)) continue;
                        move.add(MIDDLE_DOT);
                    }
                    move.add(i);
                    moves.put(i, move);
                    continue;
                }
                if (this.drawingPattern.size() < 2 || this.drawingPattern.get(this.drawingPattern.size() - 2) != i) continue;
                move = new ArrayList<Byte>(this.drawingPattern);
                move.removeLast();
                moves.put(i, move);
            }
        }
        return moves;
    }

    protected boolean selectPattern(SpellPart part, Vector2d position, float radius, Vector2d mouse) {
        if (this.drawingPart != null && this.drawingPart != part) {
            return false;
        }
        float patternRadius = radius / 2.5f;
        float pixelSize = patternRadius / 24.0f;
        if (this.drawingPattern == null) {
            this.drawingPattern = new ArrayList<Byte>();
        }
        HashMap<Byte, List<Byte>> moves = this.possibleMoves();
        for (byte i = 0; i < DOT_COUNT; i = (byte)(i + 1)) {
            Vector2f pos;
            Byte last;
            float _patternRadius = patternRadius;
            if (!this.drawingPattern.isEmpty() && SpellPartWidget.areAdjacent(last = this.drawingPattern.getLast(), i)) {
                _patternRadius += pixelSize * Trickster.CONFIG.adjacentPixelCollisionOffset() * 3.0f;
            }
            if (!SpellCircleRenderer.isInsideHitbox(pos = SpellCircleRenderer.getPatternDotPosition((float)position.x, (float)position.y, i, _patternRadius), pixelSize, mouse.x, mouse.y)) continue;
            if (this.drawingPart == null) {
                this.drawingPart = part;
                this.oldGlyph = part.glyph;
                part.glyph = new PatternGlyph(List.of());
            }
            if (moves.get(i) != null) {
                boolean removing = this.drawingPattern.size() > moves.get(i).size();
                this.drawingPattern = moves.get(i);
                class_310.method_1551().field_1724.method_17356(ModSounds.DRAW, class_3419.field_15250, 1.0f, ModSounds.randomPitch(removing ? 0.6f : 1.0f, 0.2f));
            }
            return true;
        }
        return false;
    }

    protected void stopDrawing() {
        Pattern compiled = Pattern.from(this.drawingPattern);
        int patternSize = this.drawingPattern.size();
        Optional<Revision> rev = Revisions.lookup(compiled);
        this.drawingPart.glyph = this.oldGlyph;
        if (compiled.equals(Revisions.EXECUTE_OFF_HAND.pattern())) {
            this.toBeReplaced = this.drawingPart;
            Revisions.EXECUTE_OFF_HAND.apply(this.revisionContext, this.spellPart, this.drawingPart);
        } else if (rev.isPresent()) {
            SpellPart result = rev.get().apply(this.revisionContext, this.spellPart, this.drawingPart);
            if (result != this.spellPart) {
                if (!this.parents.isEmpty()) {
                    SpellPart parent = this.parents.peek();
                    for (int i = 0; i < parent.subParts.size(); ++i) {
                        if (parent.subParts.get(i) != this.spellPart) continue;
                        parent.subParts.set(i, result);
                    }
                }
                if (this.spellPart == this.rootSpellPart) {
                    this.rootSpellPart = result;
                }
                this.spellPart = result;
            }
        } else if (this.revisionContext.getMacros().get((Object)compiled).isDefined()) {
            this.toBeReplaced = this.drawingPart;
            this.revisionContext.updateSpellWithSpell(this.drawingPart, (SpellPart)this.revisionContext.getMacros().get((Object)compiled).get());
        } else {
            this.drawingPart.glyph = patternSize >= 2 ? new PatternGlyph(compiled) : new PatternGlyph();
        }
        this.drawingPart = null;
        this.drawingPattern = null;
        this.revisionContext.updateSpell(this.rootSpellPart);
        class_310.method_1551().field_1724.method_17356(ModSounds.COMPLETE, class_3419.field_15250, 1.0f, patternSize > 1 ? 1.0f : 0.6f);
    }

    public void replaceCallback(Fragment fragment) {
        if (this.toBeReplaced != null) {
            this.toBeReplaced.glyph = fragment;
            this.toBeReplaced = null;
            this.revisionContext.updateSpell(this.rootSpellPart);
        }
    }

    public void updateDrawingPartCallback(Optional<SpellPart> spell) {
        if (this.toBeReplaced != null) {
            if (spell.isPresent()) {
                this.toBeReplaced.glyph = spell.get().glyph;
                this.toBeReplaced.subParts = spell.get().subParts;
            }
            this.toBeReplaced = null;
            this.revisionContext.updateSpell(this.rootSpellPart);
        }
    }

    public boolean isDrawing() {
        return this.drawingPart != null;
    }

    protected boolean propagateMouseEvent(double mouseX, double mouseY, MouseEventHandler callback) {
        return this.propagateMouseEvent(this.spellPart, this.position, this.radius, this.angleOffsets.peek(), SpellPartWidget.toScaledSpace(new Vector2d(mouseX, mouseY)), callback);
    }

    protected boolean propagateMouseEvent(SpellPart part, Vector2d pos, double radius, double startingAngle, Vector2d mouse, MouseEventHandler callback) {
        SpellPart inner;
        Fragment fragment;
        int closestIndex = SpellPartWidget.closestIndex(part, pos, mouse, radius, startingAngle);
        boolean centerAvailable = SpellPartWidget.isCircleClickable(SpellPartWidget.toLocalSpace(radius)) && (this.drawingPart == null || this.drawingPart == part) || part.glyph instanceof SpellPart;
        SpellPart closest = part;
        double closestDistanceSquared = Double.MAX_VALUE;
        Vector2d closestPosition = pos;
        double closestRadius = radius;
        double closestAngle = startingAngle;
        if (closestIndex > -1) {
            closest = part.subParts.get(closestIndex);
            closestPosition = part.subPosition(closestIndex, radius, startingAngle).add((Vector2dc)pos);
            closestDistanceSquared = closestPosition.distanceSquared((Vector2dc)mouse);
            closestAngle = part.subAngle(closestIndex, startingAngle);
            closestRadius = part.subRadius(radius);
        }
        if (centerAvailable && ((fragment = part.glyph) instanceof SpellPart ? this.propagateMouseEvent(inner = (SpellPart)fragment, pos, radius / 3.0, startingAngle, mouse, callback) : callback.handle(part, SpellPartWidget.toLocalSpace(pos), SpellPartWidget.toLocalSpace(radius), SpellPartWidget.toLocalSpace(mouse)))) {
            return true;
        }
        if (Math.sqrt(closestDistanceSquared) <= radius && SpellPartWidget.toLocalSpace(radius) >= 16.0f) {
            if (closest == part) {
                return false;
            }
            return this.propagateMouseEvent(closest, closestPosition, closestRadius, closestAngle, mouse, callback);
        }
        return false;
    }

    private static float toLocalSpace(double value) {
        return (float)(value * PRECISION_OFFSET);
    }

    private static double toScaledSpace(double value) {
        return value / PRECISION_OFFSET;
    }

    private static Vector2d toLocalSpace(Vector2d value) {
        return new Vector2d((Vector2dc)value).mul(PRECISION_OFFSET);
    }

    private static Vector2d toScaledSpace(Vector2d value) {
        return new Vector2d((Vector2dc)value).div(PRECISION_OFFSET);
    }

    @Environment(value=EnvType.CLIENT)
    static interface MouseEventHandler {
        public boolean handle(SpellPart var1, Vector2d var2, float var3, Vector2d var4);
    }
}

