/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell;

import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.blunder.NotEnoughManaBlunder;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.trick.Trick;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public record SpellContext(ExecutionState state, SpellSource source, TickData data) {
    public void useMana(Trick<?> trickSource, float amount) throws BlunderException {
        if (Float.isNaN(amount)) {
            throw new IllegalStateException("Internal error: Mana used is NaN");
        }
        try {
            this.state.useMana(trickSource, this, amount);
        }
        catch (NotEnoughManaBlunder blunder) {
            this.source.getPlayer().ifPresent(ModCriteria.MANA_OVERFLUX::trigger);
            throw blunder;
        }
        this.source.getPlayer().ifPresent(player -> ModCriteria.MANA_USED.trigger((class_3222)player, amount));
    }

    public void checkMana(Trick<?> trickSource, float amount) throws BlunderException {
        if (Float.isNaN(amount)) {
            throw new IllegalStateException("Internal error: Mana used is NaN");
        }
        if (this.source.getManaPool().get((class_1937)this.source.getWorld()) < amount) {
            this.source.getPlayer().ifPresent(ModCriteria.MANA_OVERFLUX::trigger);
            throw new NotEnoughManaBlunder(trickSource, amount);
        }
    }

    public MutableManaPool getManaPool() {
        return this.state().tryOverridePool(this.source.getManaPool());
    }

    public Optional<class_1799> getStack(Trick<?> trickSource, Optional<SlotFragment> optionalSlot, Predicate<class_1799> validator) throws BlunderException {
        class_1799 result = null;
        if (optionalSlot.isPresent()) {
            if (!validator.test(optionalSlot.get().reference(trickSource, this))) {
                throw new ItemInvalidBlunder(trickSource);
            }
            result = optionalSlot.get().move(trickSource, this, 1);
        } else {
            class_3222 player = this.source.getPlayer().orElseThrow(() -> new NoPlayerBlunder(trickSource));
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!validator.test(stack)) continue;
                result = stack.method_46651(1);
                stack.method_7934(1);
                break;
            }
        }
        return Optional.ofNullable(result);
    }
}

