/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellInstruction;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.util.SpellUtils;
import io.netty.buffer.ByteBuf;
import io.vavr.collection.Map;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.joml.Vector2d;

public final class SpellPart
implements Fragment {
    public static final StructEndec<SpellPart> ENDEC = EndecTomfoolery.recursive(self -> StructEndecBuilder.of((StructField)Fragment.ENDEC.fieldOf("glyph", SpellPart::getGlyph), (StructField)EndecTomfoolery.protocolVersionAlternatives(java.util.Map.of((byte)1, self.listOf()), EndecTomfoolery.withAlternative(SpellInstruction.STACK_ENDEC.xmap(instructions -> SpellUtils.decodeInstructions(instructions, new Stack<Integer>(), new Stack<Fragment>(), Optional.empty()), SpellUtils::flattenNode), self).listOf()).fieldOf("sub_parts", SpellPart::getSubParts), SpellPart::new));
    public Fragment glyph;
    public List<SpellPart> subParts;

    public SpellPart(Fragment glyph, List<SpellPart> subParts) {
        this.glyph = glyph;
        this.subParts = new ArrayList<SpellPart>(subParts);
    }

    public SpellPart(Fragment glyph) {
        this(glyph, new ArrayList<SpellPart>());
    }

    public SpellPart() {
        this(new PatternGlyph());
    }

    @Override
    public EvaluationResult activateAsGlyph(SpellContext ctx, List<Fragment> fragments) throws BlunderException {
        if (fragments.isEmpty()) {
            return Fragment.super.activateAsGlyph(ctx, fragments);
        }
        return new DefaultSpellExecutor(this, ctx.state().recurseOrThrow(fragments));
    }

    @Override
    public SpellPart applyEphemeral() {
        return new SpellPart(this.glyph.applyEphemeral(), this.subParts.stream().map(SpellPart::applyEphemeral).toList());
    }

    @Override
    public int getWeight() {
        int weight = 8;
        weight += this.glyph.getWeight();
        for (SpellPart subPart : this.subParts) {
            weight += subPart.getWeight();
        }
        return weight;
    }

    public Fragment destructiveRun(SpellContext ctx) {
        Fragment value;
        ArrayList<Fragment> arguments = new ArrayList<Fragment>();
        for (SpellPart subpart : this.subParts) {
            arguments.add(subpart.destructiveRun(ctx));
        }
        EvaluationResult result = this.glyph.activateAsGlyph(ctx, arguments);
        if (result instanceof SpellExecutor) {
            SpellExecutor executor = (SpellExecutor)result;
            value = executor.singleTickRun(ctx);
        } else if (result instanceof Fragment) {
            Fragment fragment;
            value = fragment = (Fragment)result;
        } else {
            throw new UnsupportedOperationException();
        }
        if (!value.equals(VoidFragment.INSTANCE)) {
            if (this.glyph != value) {
                this.subParts.clear();
            }
            this.glyph = value;
        }
        return value;
    }

    public SpellPart buildClosure(Map<Fragment, Fragment> replacements) {
        Object object;
        if (replacements.containsKey((Object)this) && (object = replacements.get((Object)this).get()) instanceof SpellPart) {
            SpellPart spellPart = (SpellPart)object;
            return spellPart;
        }
        this.subParts = new ArrayList<SpellPart>(this.subParts.stream().map(part -> part.buildClosure(replacements)).toList());
        object = this.glyph;
        if (object instanceof SpellPart) {
            SpellPart spellPart = (SpellPart)object;
            spellPart.buildClosure(replacements);
        } else if (replacements.containsKey((Object)this.glyph)) {
            this.glyph = (Fragment)replacements.get((Object)this.glyph).get();
        }
        return this;
    }

    public boolean setSubPartInTree(Function<SpellPart, SpellPart> replace, SpellPart current, boolean targetIsInner) {
        Fragment fragment = current.glyph;
        if (fragment instanceof SpellPart) {
            SpellPart part = (SpellPart)fragment;
            if (targetIsInner ? part.glyph == this : part == this) {
                SpellPart newPart = replace.apply(part);
                current.glyph = newPart == null ? new PatternGlyph() : newPart;
                return true;
            }
            if (this.setSubPartInTree(replace, part, targetIsInner)) {
                return true;
            }
        }
        int i = 0;
        for (SpellPart part : current.subParts) {
            if (targetIsInner ? part.glyph == this : part == this) {
                SpellPart newPart = replace.apply(part);
                if (newPart != null) {
                    current.subParts.set(i, newPart);
                } else {
                    current.subParts.remove(i);
                }
                return true;
            }
            if (this.setSubPartInTree(replace, part, targetIsInner)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Fragment getGlyph() {
        return this.glyph;
    }

    public List<SpellPart> getSubParts() {
        return this.subParts;
    }

    public boolean isEmpty() {
        PatternGlyph patternGlyph;
        Fragment fragment;
        return this.subParts.isEmpty() && (fragment = this.glyph) instanceof PatternGlyph && (patternGlyph = (PatternGlyph)fragment).pattern().isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpellPart that = (SpellPart)obj;
        return Objects.equals(this.glyph, that.glyph) && Objects.equals(this.subParts, that.subParts);
    }

    public int hashCode() {
        return Objects.hash(this.glyph, this.subParts);
    }

    public String toString() {
        return "SpellPart[glyph=" + String.valueOf(this.glyph) + ", subParts=" + String.valueOf(this.subParts) + "]";
    }

    @Override
    public FragmentType<?> type() {
        return FragmentType.SPELL_PART;
    }

    @Override
    public class_2561 asText() {
        class_5250 text = class_2561.method_43470((String)"").method_10852(this.glyph.asFormattedText()).method_27693("{");
        for (int i = 0; i < this.subParts.size(); ++i) {
            SpellPart subPart = this.subParts.get(i);
            if (i > 0) {
                text.method_27693(", ");
            }
            text.method_10852(subPart.asFormattedText());
        }
        text.method_27693("}");
        return text;
    }

    @Override
    public class_2561 asFormattedText() {
        return this.asText();
    }

    public SpellPart deepClone() {
        Fragment fragment;
        Fragment fragment2 = this.glyph;
        if (fragment2 instanceof SpellPart) {
            SpellPart spell = (SpellPart)fragment2;
            fragment = spell.deepClone();
        } else {
            fragment = this.glyph;
        }
        Fragment glyph = fragment;
        return new SpellPart(glyph, this.subParts.stream().map(SpellPart::deepClone).collect(Collectors.toList()));
    }

    public static SpellPart fromBytesOld(byte protocolVersion, ByteBuf buf) {
        SpellPart result;
        try {
            result = (SpellPart)ENDEC.decode(SerializationContext.empty().withAttributes(new SerializationAttribute.Instance[]{EndecTomfoolery.UBER_COMPACT_ATTRIBUTE, EndecTomfoolery.PROTOCOL_VERSION_ATTRIBUTE.instance((Object)protocolVersion)}), (Deserializer)ByteBufDeserializer.of((ByteBuf)buf));
        }
        finally {
            buf.release();
        }
        return result;
    }

    public int partCount() {
        return this.subParts.size();
    }

    public double subRadius(double radius) {
        return Math.min(radius / 2.0, radius / (double)((this.partCount() + 1) / 2));
    }

    public double subAngle(int index, double angleOffset) {
        return angleOffset + Math.PI * 2 / (double)this.partCount() * (double)index - 1.5707963267948966;
    }

    public Vector2d subPosition(int index, double radius, double angleOffset) {
        double angle = this.subAngle(index, angleOffset);
        return new Vector2d(Math.cos(angle), Math.sin(angle)).mul(radius);
    }
}

