/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.NaNBlunder;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.SpellExecutionManager;
import dev.enjarai.trickster.spell.execution.SpellQueueResult;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.execution.executor.ErroredSpellExecutor;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PlayerSpellExecutionManager
implements SpellExecutionManager {
    public static final StructEndec<PlayerSpellExecutionManager> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.optionalFieldOf("capacity", e -> e.capacity, (Object)5), (StructField)Endec.map(Object::toString, Integer::parseInt, SpellExecutor.ENDEC).fieldOf("spells", e -> e.spells), PlayerSpellExecutionManager::new);
    private int capacity;
    private final Int2ObjectMap<SpellExecutor> spells;

    private PlayerSpellExecutionManager(int initialCapacity, Map<Integer, SpellExecutor> spells) {
        this(initialCapacity);
        this.spells.putAll(spells);
    }

    public PlayerSpellExecutionManager(int initialCapacity) {
        this.spells = new Int2ObjectOpenHashMap(initialCapacity);
        this.capacity = initialCapacity;
    }

    public SpellQueueResult queueAndCast(SpellSource source, SpellPart spell, List<Fragment> arguments, Optional<MutableManaPool> poolOverride) {
        DefaultSpellExecutor executor = new DefaultSpellExecutor(spell, poolOverride.flatMap(pool -> Optional.of(new ExecutionState(arguments, (MutableManaPool)pool))).orElse(new ExecutionState(arguments)));
        int queued = this.queue(executor);
        if (queued >= 0) {
            ObjectIterator iterator = this.spells.int2ObjectEntrySet().iterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                if (entry.getValue() != executor) continue;
                AtomicBoolean isDone = new AtomicBoolean(true);
                this.tryRun(source, entry.getIntKey(), (SpellExecutor)entry.getValue(), (index, executor1) -> isDone.set(false), (index, executor2) -> iterator.remove(), (index, executor3) -> {});
                return new SpellQueueResult(isDone.get() ? SpellQueueResult.Type.QUEUED_DONE : SpellQueueResult.Type.QUEUED_STILL_RUNNING, executor.getDeepestState());
            }
        }
        return new SpellQueueResult(SpellQueueResult.Type.NOT_QUEUED, executor.getDeepestState());
    }

    @Override
    public int queue(SpellExecutor executor) {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            if (this.spells.putIfAbsent(i, (Object)executor) != null) continue;
            return i;
        }
        for (i = 0; i < this.capacity; ++i) {
            if (!(this.spells.get(i) instanceof ErroredSpellExecutor)) continue;
            this.spells.put(i, (Object)executor);
            return i;
        }
        return -1;
    }

    public void tick(SpellSource source, ExecutorCallback tickCallback, ExecutorCallback completeCallback, ExecutorCallback errorCallback) {
        for (int i = 0; i < this.capacity; ++i) {
            SpellExecutor spell = (SpellExecutor)this.spells.get(i);
            if (spell == null) continue;
            int i2 = i;
            this.tryRun(source, i, spell, tickCallback, (index, executor) -> {
                completeCallback.callTheBack(index, executor);
                this.spells.remove(i2);
            }, errorCallback);
        }
    }

    private boolean tryRun(SpellSource source, int key, SpellExecutor executor, ExecutorCallback tickCallback, ExecutorCallback completeCallback, ExecutorCallback errorCallback) {
        try {
            if (executor.run(source, new TickData().withSlot(key)).isEmpty()) {
                tickCallback.callTheBack(key, executor);
                return false;
            }
            completeCallback.callTheBack(key, executor);
            return true;
        }
        catch (BlunderException blunder) {
            class_5250 message = blunder.createMessage().method_27693(" (").method_10852(executor.getDeepestState().formatStackTrace()).method_27693(")");
            if (blunder instanceof NaNBlunder) {
                source.getPlayer().ifPresent(ModCriteria.NAN_NUMBER::trigger);
            }
            this.spells.put(key, (Object)new ErroredSpellExecutor(executor.spell(), (class_2561)message));
            source.getPlayer().ifPresent(player -> player.method_43496((class_2561)message));
            errorCallback.callTheBack(key, executor);
        }
        catch (Exception e) {
            class_5250 message = class_2561.method_43470((String)("Uncaught exception in spell: " + e.getMessage())).method_27693(" (").method_10852(executor.getDeepestState().formatStackTrace()).method_27693(")");
            Trickster.LOGGER.warn("Uncaught error in spell:", (Throwable)e);
            this.spells.put(key, (Object)new ErroredSpellExecutor(executor.spell(), (class_2561)message));
            source.getPlayer().ifPresent(player -> player.method_43496((class_2561)message));
            errorCallback.callTheBack(key, executor);
        }
        return true;
    }

    @Override
    public void killAll() {
        this.spells.clear();
    }

    @Override
    public boolean kill(int index) {
        if (this.spells.containsKey(index)) {
            this.spells.remove(index);
            return true;
        }
        return false;
    }

    public static interface ExecutorCallback {
        public void callTheBack(int var1, SpellExecutor var2);
    }
}

