/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution;

import dev.enjarai.trickster.Trickster;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TickData {
    private Map<Key<?>, Object> map = new HashMap();
    private int executionLimit = Trickster.CONFIG.maxExecutionsPerSpellPerTick();
    private int executions = 0;
    private Optional<Integer> slot = Optional.empty();
    private boolean killed = false;

    public void incrementExecutions() {
        ++this.executions;
    }

    public int getExecutions() {
        return this.executions;
    }

    public int getExecutionLimit() {
        return this.executionLimit;
    }

    public Optional<Integer> getSlot() {
        return this.slot;
    }

    public boolean isExecutionLimitReached() {
        return this.killed || this.executions >= this.executionLimit;
    }

    public TickData withSlot(int slot) {
        this.slot = Optional.of(slot);
        return this;
    }

    public TickData withBonusExecutions(int executions) {
        this.executionLimit += executions;
        return this;
    }

    public void kill() {
        this.killed = true;
    }

    public record Key<T>(class_2960 id, @Nullable Class<T> clazz) {
        public Optional<T> get(TickData data) {
            return Optional.ofNullable(data.map.get(this)).map(n -> n);
        }

        public T set(TickData data, T value) {
            data.map.put(this, value);
            return value;
        }
    }
}

