/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.executor;

import dev.enjarai.trickster.spell.EnterScopeInstruction;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.ExitScopeInstruction;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellInstruction;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.AtomicChunkTooLargeBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.IllegalOperationInAtomicChunkBlunder;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.SpellExecutorType;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.util.SpellUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Stack;

public class AtomicSpellExecutor
implements SpellExecutor {
    public static final StructEndec<AtomicSpellExecutor> ENDEC = StructEndecBuilder.of((StructField)SpellPart.ENDEC.fieldOf("root", e -> e.root), (StructField)SpellInstruction.STACK_ENDEC.fieldOf("instructions", e -> e.instructions), (StructField)Fragment.ENDEC.listOf().fieldOf("inputs", e -> e.inputs), (StructField)Endec.INT.listOf().fieldOf("scope", e -> e.scope), (StructField)ExecutionState.ENDEC.fieldOf("state", e -> e.state), (StructField)Endec.INT.fieldOf("required_executions", e -> e.requiredExecutions), AtomicSpellExecutor::new);
    private final SpellPart root;
    private final Stack<SpellInstruction> instructions;
    private final Stack<Fragment> inputs = new Stack();
    private final Stack<Integer> scope = new Stack();
    private final ExecutionState state;
    private final int requiredExecutions;
    private int lastRunExecutions;

    private AtomicSpellExecutor(SpellPart root, Stack<SpellInstruction> instructions, List<Fragment> inputs, List<Integer> scope, ExecutionState state, int requiredExecutions) {
        this.root = root;
        this.instructions = instructions;
        this.inputs.addAll(inputs);
        this.scope.addAll(scope);
        this.state = state;
        this.requiredExecutions = requiredExecutions;
    }

    private AtomicSpellExecutor(Trick<?> trickSource, TickData data, SpellPart root, Stack<SpellInstruction> instructions, ExecutionState state) throws BlunderException {
        this(root, instructions, List.of(), List.of(), state, AtomicSpellExecutor.calculateExecutionCost(trickSource, data, instructions));
    }

    public AtomicSpellExecutor(Trick<?> trickSource, TickData data, SpellPart root, ExecutionState state) throws BlunderException {
        this(trickSource, data, root, SpellUtils.flattenNode(root), state);
    }

    @Override
    public SpellExecutorType<?> type() {
        return SpellExecutorType.ATOMIC;
    }

    @Override
    public SpellPart spell() {
        return this.root;
    }

    @Override
    public Optional<Fragment> run(SpellSource source, TickData data) throws BlunderException {
        return this.run(new SpellContext(this.state, source, data));
    }

    @Override
    public Optional<Fragment> run(SpellContext ctx) throws BlunderException {
        this.lastRunExecutions = 0;
        if (ctx.data().getExecutions() > this.requiredExecutions) {
            return Optional.empty();
        }
        while (true) {
            if (this.state.isDelayed()) {
                throw new IllegalOperationInAtomicChunkBlunder();
            }
            SpellInstruction inst = this.instructions.pop();
            if (inst instanceof EnterScopeInstruction) {
                if (!this.scope.isEmpty()) {
                    this.state.pushStackTrace(this.scope.peek());
                }
                this.scope.push(0);
                continue;
            }
            if (inst instanceof ExitScopeInstruction) {
                this.scope.pop();
                if (this.scope.isEmpty()) {
                    return Optional.of(this.inputs.pop());
                }
                this.state.popStackTrace();
                this.scope.push(this.scope.pop() + 1);
                continue;
            }
            ArrayList<Fragment> _args = new ArrayList<Fragment>();
            for (int i = this.scope.peek().intValue(); i > 0; --i) {
                _args.add(this.inputs.pop());
            }
            SequencedCollection args = _args.reversed();
            EvaluationResult evaluationResult = inst.getActivator().orElseThrow(UnsupportedOperationException::new).apply(ctx, (List<Fragment>)args);
            if (!(evaluationResult instanceof Fragment)) {
                throw new IllegalOperationInAtomicChunkBlunder();
            }
            Fragment fragment = (Fragment)evaluationResult;
            this.inputs.push(fragment);
            ctx.data().incrementExecutions();
            this.lastRunExecutions = ctx.data().getExecutions();
        }
    }

    @Override
    public int getLastRunExecutions() {
        return this.lastRunExecutions;
    }

    @Override
    public ExecutionState getDeepestState() {
        return this.state;
    }

    private static int calculateExecutionCost(Trick<?> trickSource, TickData data, Stack<SpellInstruction> instructions) throws BlunderException {
        int cost = 0;
        for (SpellInstruction inst : instructions) {
            if (inst instanceof EnterScopeInstruction || inst instanceof ExitScopeInstruction) continue;
            ++cost;
        }
        if (cost > data.getExecutionLimit()) {
            throw new AtomicChunkTooLargeBlunder(trickSource);
        }
        return cost;
    }
}

