/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.executor;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.spell.EnterScopeInstruction;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.ExitScopeInstruction;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellInstruction;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.SpellExecutorType;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.util.SpellUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Stack;

public final class DefaultSpellExecutor
implements SpellExecutor {
    public static final StructEndec<DefaultSpellExecutor> ENDEC = StructEndecBuilder.of((StructField)SpellPart.ENDEC.fieldOf("root", e -> e.root), (StructField)SpellInstruction.STACK_ENDEC.fieldOf("instructions", e -> e.instructions), (StructField)Fragment.ENDEC.listOf().fieldOf("inputs", e -> e.inputs), (StructField)Endec.INT.listOf().fieldOf("scope", e -> e.scope), (StructField)ExecutionState.ENDEC.fieldOf("state", e -> e.state), (StructField)EndecTomfoolery.forcedSafeOptionalOf(SpellExecutor.ENDEC).fieldOf("child", e -> e.child), (StructField)EndecTomfoolery.forcedSafeOptionalOf(Fragment.ENDEC).fieldOf("override_return_value", e -> e.overrideReturnValue), DefaultSpellExecutor::new);
    public static final StructEndec<DefaultSpellExecutor> NET_ENDEC = StructEndecBuilder.of((StructField)Fragment.COMPACT_ENDEC.fieldOf("root", e -> e.root), DefaultSpellExecutor::new);
    private final SpellPart root;
    private final Stack<SpellInstruction> instructions;
    private final Stack<Fragment> inputs = new Stack();
    private final Stack<Integer> scope = new Stack();
    private ExecutionState state;
    private Optional<SpellExecutor> child = Optional.empty();
    private Optional<Fragment> overrideReturnValue = Optional.empty();
    private int lastRunExecutions;

    private DefaultSpellExecutor(SpellPart root, Stack<SpellInstruction> instructions, List<Fragment> inputs, List<Integer> scope, ExecutionState state, Optional<SpellExecutor> child, Optional<Fragment> overrideReturnValue) {
        this.root = root;
        this.instructions = instructions;
        this.inputs.addAll(inputs);
        this.scope.addAll(scope);
        this.state = state;
        this.child = child;
        this.overrideReturnValue = overrideReturnValue;
    }

    private DefaultSpellExecutor(Fragment root) {
        this((SpellPart)root, new Stack<SpellInstruction>(), new ArrayList<Fragment>(), new ArrayList<Integer>(), new ExecutionState(List.of()), Optional.empty(), Optional.empty());
    }

    public DefaultSpellExecutor(SpellPart root, ExecutionState executionState) {
        this.root = root;
        this.state = executionState;
        this.instructions = SpellUtils.flattenNode(root);
    }

    public DefaultSpellExecutor(SpellPart root, List<Fragment> arguments) {
        this(root, new ExecutionState(arguments));
    }

    @Override
    public SpellExecutorType<?> type() {
        return SpellExecutorType.DEFAULT;
    }

    @Override
    public SpellPart spell() {
        return this.root;
    }

    @Override
    public Optional<Fragment> run(SpellSource source, TickData data) throws BlunderException {
        return this.run(new SpellContext(this.state, source, data));
    }

    @Override
    public Optional<Fragment> run(SpellContext ctx) throws BlunderException {
        this.lastRunExecutions = 0;
        if (this.child.isPresent() && !this.runChild(ctx)) {
            return Optional.empty();
        }
        while (true) {
            if (this.state.isDelayed()) {
                this.state.decrementDelay();
                return Optional.empty();
            }
            if (ctx.data().isExecutionLimitReached()) {
                return Optional.empty();
            }
            SpellInstruction inst = this.instructions.pop();
            if (inst instanceof EnterScopeInstruction) {
                if (!this.scope.isEmpty()) {
                    this.state.pushStackTrace(this.scope.peek());
                }
                this.scope.push(0);
                continue;
            }
            if (inst instanceof ExitScopeInstruction) {
                this.scope.pop();
                if (this.scope.isEmpty()) {
                    return this.overrideReturnValue.or(() -> Optional.of(this.inputs.pop()));
                }
                this.state.popStackTrace();
                this.scope.push(this.scope.pop() + 1);
                continue;
            }
            ArrayList<Fragment> _args = new ArrayList<Fragment>();
            for (int i = this.scope.peek().intValue(); i > 0; --i) {
                _args.add(this.inputs.pop());
            }
            SequencedCollection args = _args.reversed();
            EvaluationResult result = inst.getActivator().orElseThrow(UnsupportedOperationException::new).apply(ctx, (List<Fragment>)args);
            if (result instanceof SpellExecutor) {
                SpellExecutor executor = (SpellExecutor)result;
                boolean isTail = true;
                VoidFragment returnValue = null;
                if (this.instructions.size() > 1) {
                    for (SpellInstruction instruction : this.instructions) {
                        PatternGlyph patternGlyph;
                        if (instruction instanceof ExitScopeInstruction) continue;
                        if (instruction instanceof PatternGlyph && (patternGlyph = (PatternGlyph)instruction).pattern().isEmpty()) {
                            returnValue = VoidFragment.INSTANCE;
                            continue;
                        }
                        isTail = false;
                        break;
                    }
                }
                if (isTail && executor instanceof DefaultSpellExecutor) {
                    DefaultSpellExecutor defaultExecutor = (DefaultSpellExecutor)executor;
                    this.instructions.clear();
                    this.inputs.clear();
                    this.scope.clear();
                    if (this.overrideReturnValue.isEmpty()) {
                        this.overrideReturnValue = Optional.ofNullable(returnValue);
                    }
                    this.instructions.addAll(defaultExecutor.instructions);
                    this.state = defaultExecutor.state;
                    this.state.decrementRecursions();
                    ctx = new SpellContext(this.state, ctx.source(), ctx.data());
                } else {
                    this.child = Optional.of(executor);
                    if (!this.runChild(ctx)) {
                        return Optional.empty();
                    }
                }
            } else if (result instanceof Fragment) {
                Fragment fragment = (Fragment)result;
                this.inputs.push(fragment);
            } else {
                throw new UnsupportedOperationException();
            }
            ctx.data().incrementExecutions();
            this.lastRunExecutions = ctx.data().getExecutions();
        }
    }

    private boolean runChild(SpellContext ctx) {
        Optional result = this.child.flatMap(c -> c.run(ctx.source(), ctx.data()));
        if (result.isPresent()) {
            this.inputs.push((Fragment)result.get());
            this.child = Optional.empty();
        }
        return result.isPresent();
    }

    @Override
    public int getLastRunExecutions() {
        return this.child.map(SpellExecutor::getLastRunExecutions).orElse(this.lastRunExecutions);
    }

    @Override
    public ExecutionState getDeepestState() {
        return this.child.map(SpellExecutor::getDeepestState).orElse(this.state);
    }
}

