/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.executor;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.cca.MessageHandlerComponent;
import dev.enjarai.trickster.cca.ModGlobalComponents;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.SpellExecutorType;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class MessageListenerSpellExecutor
implements SpellExecutor {
    public static final StructEndec<MessageListenerSpellExecutor> ENDEC = StructEndecBuilder.of((StructField)ExecutionState.ENDEC.fieldOf("state", e -> e.state), (StructField)EndecTomfoolery.forcedSafeOptionalOf(EndecTomfoolery.UUID.xmap(MessageHandlerComponent.Key.Channel::new, MessageHandlerComponent.Key.Channel::uuid)).fieldOf("channel", e -> e.channel), (StructField)Endec.INT.optionalFieldOf("ticksLeft", e -> e.ticksLeft, (Object)0), (StructField)EndecTomfoolery.forcedSafeOptionalOf(ListFragment.ENDEC).fieldOf("result", e -> e.result), MessageListenerSpellExecutor::new);
    private final ExecutionState state;
    private final Optional<MessageHandlerComponent.Key.Channel> channel;
    private int ticksLeft;
    private Optional<ListFragment> result = Optional.empty();

    private MessageListenerSpellExecutor(ExecutionState state, Optional<MessageHandlerComponent.Key.Channel> channel, int ticksLeft, Optional<ListFragment> result) {
        this.state = state;
        this.channel = channel;
        this.ticksLeft = ticksLeft;
        this.result = result;
    }

    public MessageListenerSpellExecutor(ExecutionState state, int timeout, Optional<MessageHandlerComponent.Key.Channel> channel) {
        this(state, channel, timeout >= 0 ? timeout + 1 : -1, Optional.empty());
    }

    @Override
    public SpellExecutorType<?> type() {
        return SpellExecutorType.MESSAGE_LISTENER;
    }

    @Override
    public SpellPart spell() {
        return new SpellPart();
    }

    @Override
    public Optional<Fragment> run(SpellSource source, TickData data) throws BlunderException {
        if (this.ticksLeft == 0) {
            return Optional.of(new ListFragment(List.of()));
        }
        if (this.result.isEmpty()) {
            ((MessageHandlerComponent)ModGlobalComponents.MESSAGE_HANDLER.get((Object)source.getWorld().method_14170())).await(this.channel.map(n -> n).orElseGet(() -> new MessageHandlerComponent.Key.Broadcast((class_5321<class_1937>)source.getWorld().method_27983(), source.getPos(), 0.0)), this::listen);
        }
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
        }
        return this.result.map(n -> n);
    }

    @Override
    public Optional<Fragment> run(SpellContext ctx) throws BlunderException {
        return this.run(ctx.source(), ctx.data());
    }

    @Override
    public int getLastRunExecutions() {
        return 0;
    }

    @Override
    public ExecutionState getDeepestState() {
        return this.state;
    }

    private void listen(ListFragment value) {
        this.result = Optional.of(value);
    }
}

