/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.fragment;

import com.mojang.datafixers.util.Either;
import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.pond.SlotHolderDuck;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlockInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.EntityInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.ImmutableItemBlunder;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.MissingItemBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.blunder.NoSuchSlotBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.trick.Trick;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.EitherEndec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record SlotFragment(int slot, Optional<Either<class_2338, UUID>> source) implements Fragment
{
    public static final StructEndec<SlotFragment> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("slot", SlotFragment::slot), (StructField)EndecTomfoolery.safeOptionalOf(new EitherEndec(EndecTomfoolery.ALWAYS_READABLE_BLOCK_POS, EndecTomfoolery.UUID, true)).fieldOf("source", SlotFragment::source), SlotFragment::new);

    @Override
    public FragmentType<?> type() {
        return FragmentType.SLOT;
    }

    @Override
    public class_2561 asText() {
        return class_2561.method_43470((String)"slot %d at %s".formatted(this.slot, this.source.map(either -> {
            Either mapped = either.mapLeft(blockPos -> "%d, %d, %d".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())).mapRight(uuid -> uuid.toString());
            return mapped.right().orElseGet(() -> (String)mapped.left().get());
        }).orElse("caster")));
    }

    @Override
    public int getWeight() {
        return 64;
    }

    public void setStack(class_1799 itemStack, Trick<?> trick, SpellContext ctx) {
        SlotHolderDuck inventory = this.getInventory(trick, ctx);
        inventory.trickster$slot_holder$setStack(this.slot, itemStack);
    }

    public void writeFragment(Fragment fragment, boolean closed, Optional<class_2561> name, Optional<class_3222> player, Trick<?> trick, SpellContext ctx) throws BlunderException {
        SlotHolderDuck inventory = this.getInventory(trick, ctx);
        class_1799 stack = inventory.trickster$slot_holder$getStack(this.slot);
        Optional<class_1799> updated = FragmentComponent.write(stack, fragment, closed, player, name);
        inventory.trickster$slot_holder$setStack(this.slot, updated.orElseThrow(() -> new ImmutableItemBlunder(trick)));
    }

    public void resetFragment(Trick<?> trick, SpellContext ctx) throws BlunderException {
        SlotHolderDuck inventory = this.getInventory(trick, ctx);
        class_1799 stack = inventory.trickster$slot_holder$getStack(this.slot);
        Optional<class_1799> updated = FragmentComponent.reset(stack);
        inventory.trickster$slot_holder$setStack(this.slot, updated.orElseThrow(() -> new ImmutableItemBlunder(trick)));
    }

    public void swapWith(Trick<?> trickSource, SpellContext ctx, SlotFragment other) throws BlunderException {
        SlotHolderDuck otherInv = other.getInventory(trickSource, ctx);
        SlotHolderDuck inv = this.getInventory(trickSource, ctx);
        if (this.equals(other)) {
            class_1799 stack = inv.trickster$slot_holder$takeFromSlot(this.slot, this.getStack(trickSource, ctx).method_7947());
            inv.trickster$slot_holder$setStack(this.slot, stack);
        } else {
            class_1799 movedStack;
            class_1799 otherStack = other.getStack(trickSource, ctx);
            class_1799 stack = this.getStack(trickSource, ctx);
            class_1799 movedOtherStack = other.move(trickSource, ctx, otherStack.method_7947(), this.getSourcePos(trickSource, ctx));
            try {
                movedStack = this.move(trickSource, ctx, stack.method_7947(), other.getSourcePos(trickSource, ctx));
            }
            catch (Exception e) {
                ctx.source().offerOrDropItem(movedOtherStack);
                throw e;
            }
            try {
                if (!inv.trickster$slot_holder$setStack(this.slot, movedOtherStack)) {
                    throw new ItemInvalidBlunder(trickSource);
                }
            }
            catch (Exception e) {
                ctx.source().offerOrDropItem(movedOtherStack);
                ctx.source().offerOrDropItem(movedStack);
                throw e;
            }
            try {
                if (!otherInv.trickster$slot_holder$setStack(other.slot(), movedStack)) {
                    throw new ItemInvalidBlunder(trickSource);
                }
            }
            catch (UnsupportedOperationException e) {
                throw new ItemInvalidBlunder(trickSource);
            }
            catch (Exception e) {
                ctx.source().offerOrDropItem(movedStack);
                throw e;
            }
        }
    }

    public class_1799 move(Trick<?> trickSource, SpellContext ctx) throws BlunderException {
        return this.move(trickSource, ctx, 1);
    }

    public class_1799 move(Trick<?> trickSource, SpellContext ctx, int amount) {
        return this.move(trickSource, ctx, amount, (Vector3dc)ctx.source().getPos());
    }

    public class_1799 move(Trick<?> trickSource, SpellContext ctx, int amount, Vector3dc pos) throws BlunderException {
        class_1799 stack = this.getStack(trickSource, ctx);
        if (stack.method_7947() < amount) {
            throw new MissingItemBlunder(trickSource);
        }
        ctx.useMana(trickSource, this.getMoveCost(trickSource, ctx, pos, amount));
        return this.takeFromSlot(trickSource, ctx, amount);
    }

    public class_1799 reference(Trick<?> trickSource, SpellContext ctx) {
        return this.getStack(trickSource, ctx);
    }

    public class_1792 getItem(Trick<?> trickSource, SpellContext ctx) throws BlunderException {
        return this.getStack(trickSource, ctx).method_7909();
    }

    public Vector3dc getSourcePos(Trick<?> trickSource, SpellContext ctx) {
        return this.source.map(either -> (class_243)Either.unwrap((Either)either.mapLeft(blockPos -> blockPos.method_46558()).mapRight(uuid -> new EntityFragment((UUID)uuid, (class_2561)class_2561.method_43470((String)"")).getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder(trickSource)).method_19538()))).orElseGet(() -> ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(trickSource)).method_19538()).toVector3d();
    }

    private class_1799 getStack(Trick<?> trickSource, SpellContext ctx) throws BlunderException {
        SlotHolderDuck inventory = this.getInventory(trickSource, ctx);
        if (this.slot < 0 || this.slot >= inventory.trickster$slot_holder$size()) {
            throw new NoSuchSlotBlunder(trickSource);
        }
        return inventory.trickster$slot_holder$getStack(this.slot);
    }

    private class_1799 takeFromSlot(Trick<?> trickSource, SpellContext ctx, int amount) throws BlunderException {
        SlotHolderDuck inventory = this.getInventory(trickSource, ctx);
        if (this.slot < 0 || this.slot >= inventory.trickster$slot_holder$size()) {
            throw new NoSuchSlotBlunder(trickSource);
        }
        return inventory.trickster$slot_holder$takeFromSlot(this.slot, amount);
    }

    private SlotHolderDuck getInventory(Trick<?> trickSource, SpellContext ctx) throws BlunderException {
        return this.source.map(s -> {
            if (s.left().isPresent()) {
                class_2586 e = ctx.source().getWorld().method_8321((class_2338)s.left().get());
                if (e instanceof SlotHolderDuck) {
                    SlotHolderDuck holder = (SlotHolderDuck)e;
                    return holder;
                }
                if (e instanceof class_1263) {
                    class_1263 inv = (class_1263)e;
                    return new BridgedSlotHolder(this, inv);
                }
                throw new BlockInvalidBlunder(trickSource);
            }
            class_1297 e = ctx.source().getWorld().method_14190((UUID)s.right().get());
            if (e instanceof SlotHolderDuck) {
                SlotHolderDuck holder = (SlotHolderDuck)e;
                return holder;
            }
            if (e instanceof class_1263) {
                class_1263 inv = (class_1263)e;
                return new BridgedSlotHolder(this, inv);
            }
            throw new EntityInvalidBlunder(trickSource);
        }).orElseGet(() -> ctx.source().getPlayer().map(player -> new BridgedSlotHolder(this, (class_1263)player.method_31548())).orElseThrow(() -> new NoPlayerBlunder(trickSource)));
    }

    private float getMoveCost(Trick<?> trickSource, SpellContext ctx, Vector3dc pos, int amount) throws BlunderException {
        Vector3d sourcePos = this.source.map(s -> {
            if (s.left().isPresent()) {
                return ((class_2338)s.left().get()).method_46558();
            }
            class_1297 patt0$temp = ctx.source().getWorld().method_14190((UUID)s.right().get());
            if (patt0$temp instanceof class_1297) {
                class_1297 entity = patt0$temp;
                return entity.method_24515().method_46558();
            }
            throw new EntityInvalidBlunder(trickSource);
        }).orElseGet(() -> ctx.source().getBlockPos().method_46558()).toVector3d();
        return (float)(pos.distance((Vector3dc)sourcePos) * (double)amount * 0.5);
    }

    private class BridgedSlotHolder
    implements SlotHolderDuck {
        private class_1263 inv;

        public BridgedSlotHolder(SlotFragment slotFragment, class_1263 inv) {
            this.inv = inv;
        }

        @Override
        public int trickster$slot_holder$size() {
            return this.inv.method_5439();
        }

        @Override
        public class_1799 trickster$slot_holder$getStack(int slot) {
            return this.inv.method_5438(slot);
        }

        @Override
        public boolean trickster$slot_holder$setStack(int slot, class_1799 stack) {
            if (!this.inv.method_5437(slot, stack)) {
                return false;
            }
            this.inv.method_5447(slot, stack);
            return true;
        }

        @Override
        public class_1799 trickster$slot_holder$takeFromSlot(int slot, int amount) {
            class_1799 stack = this.inv.method_5438(slot);
            class_1799 result = stack.method_46651(amount);
            stack.method_7934(amount);
            return result;
        }
    }
}

