/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.mana;

import dev.enjarai.trickster.spell.mana.ManaPoolType;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.mana.SimpleManaPool;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.class_1937;

public class SavingsManaPool
extends SimpleManaPool {
    public static final StructEndec<SavingsManaPool> ENDEC = StructEndecBuilder.of((StructField)Endec.FLOAT.fieldOf("mana", pool -> Float.valueOf(pool.mana)), (StructField)Endec.FLOAT.fieldOf("max_mana", pool -> Float.valueOf(pool.maxMana)), (StructField)Endec.FLOAT.fieldOf("interest", pool -> Float.valueOf(pool.interest)), (StructField)Endec.LONG.fieldOf("last_update_time", pool -> pool.lastUpdateTime), SavingsManaPool::new);
    protected final float interest;
    protected long lastUpdateTime;

    protected SavingsManaPool(float mana, float maxMana, float interest, long lastUpdateTime) {
        super(mana, maxMana);
        this.interest = interest;
        this.lastUpdateTime = lastUpdateTime;
    }

    public SavingsManaPool(float maxMana, float interest) {
        super(maxMana);
        this.interest = interest;
    }

    @Override
    public ManaPoolType<?> type() {
        return ManaPoolType.SAVINGS;
    }

    @Override
    public void set(float value, class_1937 world) {
        this.lastUpdateTime = world.method_8510();
        super.set(value, world);
    }

    @Override
    public float get(class_1937 world) {
        long ticksPassed = world.method_8510() - this.lastUpdateTime;
        float lastMana = super.get(world);
        return (float)Math.clamp((double)lastMana * Math.pow(1.0f + this.interest, ticksPassed), 0.0, (double)this.getMax(world));
    }

    @Override
    public MutableManaPool makeClone(class_1937 world) {
        return new SavingsManaPool(this.mana, this.maxMana, this.interest, this.lastUpdateTime);
    }
}

