/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick;

import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DistortionTrick<T extends DistortionTrick<T>>
extends Trick<T> {
    private static final int CACHE_SIZE = 20;
    private final Map<Fragment[], Fragment> cache = new LinkedHashMap<Fragment[], Fragment>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Fragment[], Fragment> eldest) {
            return this.size() > 20;
        }
    };

    public DistortionTrick(Pattern pattern) {
        super(pattern);
    }

    public DistortionTrick(Pattern pattern, List<Signature<T>> handlers) {
        super(pattern, handlers);
    }

    public DistortionTrick(Pattern pattern, Signature<T> primary) {
        super(pattern, primary);
    }

    @Override
    public EvaluationResult activate(SpellContext ctx, List<Fragment> fragments) throws BlunderException {
        Fragment[] fragmentArray = fragments.toArray(new Fragment[0]);
        EvaluationResult result = this.cache.get(fragmentArray);
        if (result == null && (result = super.activate(ctx, fragments)) instanceof Fragment) {
            Fragment fragment = (Fragment)result;
            this.cache.put(fragmentArray, fragment);
        }
        return result;
    }
}

