/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.cca.CasterComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.CantEditBlockBlunder;
import dev.enjarai.trickster.spell.blunder.InvalidInputsBlunder;
import dev.enjarai.trickster.spell.blunder.NotLoadedBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Tricks;
import dev.enjarai.trickster.spell.type.ClassListArgType;
import dev.enjarai.trickster.spell.type.ClassMapArgType;
import dev.enjarai.trickster.spell.type.ClassVariadicArgType;
import dev.enjarai.trickster.spell.type.Signature;
import dev.enjarai.trickster.spell.type.SimpleArgType;
import dev.enjarai.trickster.spell.type.TypeListArgType;
import dev.enjarai.trickster.spell.type.TypeMapArgType;
import dev.enjarai.trickster.spell.type.TypeVariadicArgType;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

public abstract class Trick<T extends Trick<T>> {
    public static final class_2960 TRICK_RANDOM = Trickster.id("trick");
    protected static final SimpleArgType<Fragment> ANY = Trick.simple(Fragment.class);
    protected static final ClassVariadicArgType<Fragment> ANY_VARIADIC = Trick.variadic(Fragment.class);
    protected final Pattern pattern;
    private final List<Signature<T>> handlers;

    public Trick(Pattern pattern, List<Signature<T>> handlers) {
        this.pattern = pattern;
        this.handlers = handlers;
    }

    public Trick(Pattern pattern, Signature<T> primary) {
        this(pattern);
        this.handlers.add(primary);
    }

    public Trick(Pattern pattern) {
        this(pattern, new ArrayList<Signature<T>>());
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public Trick<T> overload(Signature<T> signature) {
        this.handlers.add(signature);
        return this;
    }

    public EvaluationResult activate(SpellContext ctx, List<Fragment> fragments) throws BlunderException {
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            Signature<Trick> handler = this.handlers.get(i);
            if (!handler.match(fragments)) continue;
            return handler.run(this, ctx, fragments);
        }
        throw new InvalidInputsBlunder(this, fragments);
    }

    protected static <T extends Fragment> SimpleArgType<T> simple(Class<T> type) {
        return new SimpleArgType<T>(type);
    }

    @SafeVarargs
    protected static <T extends Fragment> ClassVariadicArgType<T> variadic(Class<T> ... types) {
        return new ClassVariadicArgType<T>(types);
    }

    @SafeVarargs
    protected static <T extends Fragment> TypeVariadicArgType<T> variadic(FragmentType<T> ... types) {
        return new TypeVariadicArgType<T>(types);
    }

    @SafeVarargs
    protected static <T extends Fragment> ClassListArgType<T> list(Class<T> ... types) {
        return new ClassListArgType<T>(types);
    }

    @SafeVarargs
    protected static <T extends Fragment> TypeListArgType<T> list(FragmentType<T> ... types) {
        return new TypeListArgType<T>(types);
    }

    protected static <K extends Fragment, V extends Fragment> ClassMapArgType<K, V> map(Class<K> keyType, Class<V> valueType) {
        return new ClassMapArgType<K, V>(keyType, valueType);
    }

    protected static <K extends Fragment, V extends Fragment> TypeMapArgType<K, V> map(FragmentType<K> keyType, FragmentType<V> valueType) {
        return new TypeMapArgType<K, V>(keyType, valueType);
    }

    protected void expectCanBuild(SpellContext ctx, class_2338 ... positions) {
        if (ctx.source().getPlayer().isEmpty()) {
            return;
        }
        class_3222 player = ctx.source().getPlayer().get();
        if (player.field_13974.method_14257().method_8387()) {
            throw new CantEditBlockBlunder(this, positions[0]);
        }
        this.expectLoaded(ctx, positions);
        for (class_2338 pos : positions) {
            if (player.method_36971((class_1937)ctx.source().getWorld(), pos)) continue;
            throw new CantEditBlockBlunder(this, pos);
        }
    }

    protected void expectLoaded(SpellContext ctx, class_2338 ... positions) {
        for (class_2338 pos : positions) {
            if (ctx.source().getWorld().method_8393(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()))) continue;
            throw new NotLoadedBlunder(this, pos);
        }
    }

    protected void tryWard(SpellContext triggerCtx, class_1297 target, List<Fragment> fragments) throws BlunderException {
        if (target instanceof class_3222) {
            class_3222 player = (class_3222)target;
            Optional<class_1297> triggerCaster = triggerCtx.source().getCaster();
            if (triggerCaster.map(c -> c.equals((Object)player)).orElse(false).booleanValue()) {
                return;
            }
            ModCriteria.TRIGGER_WARD.trigger(player);
            Fragment sourceFragment = triggerCaster.map(EntityFragment::from).orElse(new VectorFragment((Vector3dc)triggerCtx.source().getPos()));
            HashMap<Pattern, SpellPart> charmMap = FragmentComponent.getUserMergedMap((class_1657)player, "charm", HashMap::empty);
            Option spell = charmMap.get((Object)this.getPattern());
            CasterComponent caster = (CasterComponent)ModEntityComponents.CASTER.get((Object)player);
            spell.peek(s -> caster.queueSpellAndCast((SpellPart)s, List.of(sourceFragment, new ListFragment(fragments)), Optional.empty()));
        }
    }

    @Nullable
    public Set<UUID> restricted() {
        return null;
    }

    public class_5250 getName() {
        class_2960 id = Tricks.REGISTRY.method_10221((Object)this);
        if (id == null) {
            return class_2561.method_43470((String)"Unregistered");
        }
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)("trickster.trick." + id.method_12836() + "." + id.method_12832())).method_54663(FragmentType.PATTERN.color().getAsInt()));
    }

    public List<Signature<T>> getSignatures() {
        return this.handlers;
    }
}

