/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.block;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.particle.ModParticles;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlockInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.BlockUnoccupiedBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.OverlapBlunder;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import dev.enjarai.trickster.util.Trolling;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class SwapBlockTrick
extends Trick<SwapBlockTrick> {
    public SwapBlockTrick() {
        super(Pattern.of(3, 4, 5, 8, 4, 0, 3, 6, 4, 2, 5), Signature.of(FragmentType.VECTOR, FragmentType.VECTOR, SwapBlockTrick::run));
    }

    public Fragment run(SpellContext ctx, VectorFragment pos1, VectorFragment pos2) throws BlunderException {
        class_2338 blockPos1 = pos1.toBlockPos();
        class_2338 blockPos2 = pos2.toBlockPos();
        class_3218 world = ctx.source().getWorld();
        if (blockPos1.equals((Object)blockPos2)) {
            throw new OverlapBlunder(this, pos1, pos2);
        }
        this.expectCanBuild(ctx, blockPos1, blockPos2);
        class_2680 state1 = world.method_8320(blockPos1);
        class_2680 state2 = world.method_8320(blockPos2);
        if (state1.method_26215()) {
            throw new BlockUnoccupiedBlunder(this, pos1);
        }
        if (state2.method_26215()) {
            throw new BlockUnoccupiedBlunder(this, pos2);
        }
        if (!Trickster.CONFIG.allowSwapBedrock()) {
            if (state1.method_26214((class_1922)world, blockPos1) < 0.0f) {
                throw new BlockInvalidBlunder(this);
            }
            if (state2.method_26214((class_1922)world, blockPos2) < 0.0f) {
                throw new BlockInvalidBlunder(this);
            }
        }
        ctx.useMana(this, (float)(60.0 + pos1.vector().distance(pos2.vector())));
        class_2487 blockEntity1Nbt = null;
        class_2487 blockEntity2Nbt = null;
        class_2586 blockEntity1 = world.method_8321(blockPos1);
        class_2586 blockEntity2 = world.method_8321(blockPos2);
        if (blockEntity1 != null) {
            blockEntity1Nbt = blockEntity1.method_38244((class_7225.class_7874)world.method_30349());
            Trolling.clearBlockEntityForDeletion((class_1937)world, blockEntity1);
        }
        if (blockEntity2 != null) {
            blockEntity2Nbt = blockEntity2.method_38244((class_7225.class_7874)world.method_30349());
            Trolling.clearBlockEntityForDeletion((class_1937)world, blockEntity2);
        }
        world.method_8501(blockPos1, state2);
        world.method_8501(blockPos2, state1);
        if (blockEntity1Nbt != null) {
            world.method_8321(blockPos2).method_58690(blockEntity1Nbt, (class_7225.class_7874)world.method_30349());
        }
        if (blockEntity2Nbt != null) {
            world.method_8321(blockPos1).method_58690(blockEntity2Nbt, (class_7225.class_7874)world.method_30349());
        }
        class_243 particlePos1 = blockPos1.method_46558();
        class_243 particlePos2 = blockPos2.method_46558();
        world.method_14199((class_2394)ModParticles.PROTECTED_BLOCK, particlePos1.field_1352, particlePos1.field_1351, particlePos1.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        world.method_14199((class_2394)ModParticles.PROTECTED_BLOCK, particlePos2.field_1352, particlePos2.field_1351, particlePos2.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        return VoidFragment.INSTANCE;
    }
}

