/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.entity;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.cca.EntityWeightComponent;
import dev.enjarai.trickster.cca.GraceComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.entity.LevitatingBlockEntity;
import dev.enjarai.trickster.particle.ModParticles;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlockInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.EntityInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NumberTooLargeBlunder;
import dev.enjarai.trickster.spell.blunder.NumberTooSmallBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ChangeWeightTrick
extends Trick<ChangeWeightTrick> {
    public ChangeWeightTrick() {
        super(Pattern.of(0, 3, 6, 7, 4, 1, 2, 5, 8), Signature.of(FragmentType.ENTITY.wardOf(), FragmentType.NUMBER, ChangeWeightTrick::change));
        this.overload(Signature.of(FragmentType.VECTOR, FragmentType.NUMBER, ChangeWeightTrick::change));
    }

    public Fragment change(SpellContext ctx, EntityFragment target, NumberFragment number) throws BlunderException {
        class_1297 entity = target.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder(this));
        double weight = number.number();
        if (weight > 1.0) {
            throw new NumberTooLargeBlunder(this, 1);
        }
        if (weight < 0.0) {
            throw new NumberTooSmallBlunder(this, 0);
        }
        if (entity instanceof LevitatingBlockEntity) {
            LevitatingBlockEntity levitatingBlock = (LevitatingBlockEntity)entity;
            ctx.useMana(this, (float)(60.0 * (1.0 - weight)));
            levitatingBlock.setWeight((float)weight);
            levitatingBlock.setShouldRevertNow(weight >= 1.0);
            ((GraceComponent)ModEntityComponents.GRACE.get((Object)entity)).triggerGrace("weight", 20);
        } else {
            if (!(entity instanceof class_1309)) {
                throw new EntityInvalidBlunder(this);
            }
            ctx.useMana(this, (float)(60.0 * (1.0 - weight)));
            ((EntityWeightComponent)ModEntityComponents.WEIGHT.get((Object)entity)).setWeight(weight);
            ((GraceComponent)ModEntityComponents.GRACE.get((Object)entity)).triggerGrace("weight", 20);
        }
        return target;
    }

    public Fragment change(SpellContext ctx, VectorFragment target, NumberFragment number) throws BlunderException {
        class_3218 world = ctx.source().getWorld();
        class_2338 blockPos = target.toBlockPos();
        class_2680 state = world.method_8320(blockPos);
        double weight = number.number();
        if (weight > 1.0) {
            throw new NumberTooLargeBlunder(this, 1);
        }
        if (weight < 0.0) {
            throw new NumberTooSmallBlunder(this, 0);
        }
        if (state.method_26215() || state.method_26204() instanceof class_2404 || !Trickster.CONFIG.allowSwapBedrock() && state.method_26214((class_1922)world, blockPos) < 0.0f) {
            throw new BlockInvalidBlunder(this);
        }
        ctx.useMana(this, (float)(60.0 * (1.0 - weight)));
        LevitatingBlockEntity levitatingBlock = LevitatingBlockEntity.spawnFromBlock((class_1937)ctx.source().getWorld(), target.toBlockPos(), state, (float)weight);
        ((GraceComponent)ModEntityComponents.GRACE.get((Object)levitatingBlock)).triggerGrace("weight", 20);
        class_243 particlePos = target.toBlockPos().method_46558();
        ctx.source().getWorld().method_14199((class_2394)ModParticles.PROTECTED_BLOCK, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        return EntityFragment.from(levitatingBlock);
    }
}

