/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.entity;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.OutOfRangeBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.EntityTypeFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import org.joml.Vector3dc;

public class RangeFindEntityTrick
extends Trick<RangeFindEntityTrick> {
    public RangeFindEntityTrick() {
        super(Pattern.of(3, 1, 0, 3, 6, 7, 8, 5, 7), Signature.of(FragmentType.VECTOR, FragmentType.NUMBER, RangeFindEntityTrick.variadic(FragmentType.ENTITY_TYPE).unpack(), RangeFindEntityTrick::run));
    }

    public Fragment run(SpellContext ctx, VectorFragment posFragment, NumberFragment rangeFragment, List<EntityTypeFragment> typeFragments) throws BlunderException {
        ArrayList types = new ArrayList(typeFragments.size());
        Vector3dc pos = posFragment.vector();
        double range = rangeFragment.number();
        if (range > 32.0) {
            throw new OutOfRangeBlunder(this, 32.0, range);
        }
        for (EntityTypeFragment type : typeFragments) {
            types.add(type.entityType());
        }
        double squaredRange = range * range;
        ArrayList entities = new ArrayList();
        class_3218 world = ctx.source().getWorld();
        world.method_47574(class_5575.method_31795(class_1297.class), new class_238(pos.x() - range, pos.y() - range, pos.z() - range, pos.x() + range, pos.y() + range, pos.z() + range), e -> e.method_19538().method_1028(pos.x(), pos.y(), pos.z()) <= squaredRange && world.method_14190(e.method_5667()) != null && types.contains(e.method_5864()), entities);
        return new ListFragment(entities.stream().filter(EntityFragment::isValidEntity).map(EntityFragment::from).toList());
    }
}

