/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.entity;

import dev.enjarai.trickster.entity.ModEntities;
import dev.enjarai.trickster.item.component.EntityStorageComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.EntityAlreadyStoredBlunder;
import dev.enjarai.trickster.spell.blunder.EntityCannotBeStoredBlunder;
import dev.enjarai.trickster.spell.blunder.EntityInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownEntityBlunder;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class StoreEntityTrick
extends Trick<StoreEntityTrick> {
    public StoreEntityTrick() {
        super(Pattern.of(5, 2, 4, 3, 6, 7, 4), Signature.of(FragmentType.ENTITY, StoreEntityTrick::store));
    }

    public Fragment store(SpellContext ctx, EntityFragment entity) throws BlunderException {
        class_1297 target = entity.getEntity(ctx).orElseThrow(() -> new UnknownEntityBlunder(this));
        if (target instanceof class_1657) {
            throw new EntityInvalidBlunder(this);
        }
        if (target.method_5864().method_20210(ModEntities.IRREPRESSIBLE)) {
            throw new EntityCannotBeStoredBlunder(this, target);
        }
        class_3222 player = ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(this));
        class_1799 offhand = player.method_6079();
        EntityStorageComponent entityStorage = (EntityStorageComponent)offhand.method_57824(ModComponents.ENTITY_STORAGE);
        if (entityStorage == null) {
            throw new ItemInvalidBlunder(this);
        }
        if (!entityStorage.nbt().isEmpty()) {
            throw new EntityAlreadyStoredBlunder(this);
        }
        double dist = player.method_19538().method_1022(target.method_19538());
        ctx.useMana(this, (float)(2000.0 + Math.pow(dist, dist / 5.0)));
        class_2487 compound = new class_2487();
        target.method_5786(compound);
        offhand.method_57379(ModComponents.ENTITY_STORAGE, (Object)new EntityStorageComponent(Optional.of(compound)));
        target.method_5650(class_1297.class_5529.field_27002);
        return VoidFragment.INSTANCE;
    }
}

