/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.inventory;

import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.mana.ManaPool;
import dev.enjarai.trickster.spell.mana.SharedManaPool;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class GetManaInSlotTrick
extends Trick<GetManaInSlotTrick> {
    public GetManaInSlotTrick() {
        super(Pattern.of(3, 4, 5, 2, 4, 0, 3, 6, 8, 5), Signature.of(GetManaInSlotTrick.variadic(FragmentType.SLOT).unpack(), GetManaInSlotTrick::run));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Fragment run(SpellContext ctx, List<SlotFragment> slots) throws BlunderException {
        float result = 0.0f;
        ArrayList<UUID> identifiedKnots = new ArrayList<UUID>();
        Iterator<SlotFragment> iterator = slots.iterator();
        while (iterator.hasNext()) {
            SlotFragment slot = iterator.next();
            class_1799 stack = slot.reference(this, ctx);
            ManaComponent comp = (ManaComponent)stack.method_57824(ModComponents.MANA);
            if (comp == null) continue;
            ManaPool manaPool = comp.pool();
            if (manaPool instanceof SharedManaPool) {
                SharedManaPool sharedManaPool = (SharedManaPool)manaPool;
                try {
                    UUID uUID;
                    UUID uuid = uUID = sharedManaPool.uuid();
                    if (identifiedKnots.contains(uuid)) continue;
                    identifiedKnots.add(uuid);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            result += comp.pool().get((class_1937)ctx.source().getWorld());
        }
        return new NumberFragment(result);
    }
}

