/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.mana;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.advancement.criterion.ModCriteria;
import dev.enjarai.trickster.item.KnotItem;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.MissingItemBlunder;
import dev.enjarai.trickster.spell.blunder.NoPlayerBlunder;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class BatteryCreationTrick
extends Trick<BatteryCreationTrick> {
    private Map<class_1792, KnotItem> types = new HashMap<class_1792, KnotItem>();

    public BatteryCreationTrick() {
        super(Pattern.of(6, 8, 5, 2, 1, 8, 7, 6, 1, 0, 3, 6), Signature.of(FragmentType.SLOT.optionalOf(), FragmentType.SLOT.optionalOf(), BatteryCreationTrick::run));
    }

    public Fragment run(SpellContext ctx, Optional<SlotFragment> slot1, Optional<SlotFragment> slot2) throws BlunderException {
        SlotFragment sourceSlot = slot1.orElseGet(() -> {
            class_3222 player = ctx.source().getPlayer().orElseThrow(() -> new NoPlayerBlunder(this));
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!stack.method_31574(class_1802.field_27063)) continue;
                return new SlotFragment(i, Optional.empty());
            }
            throw new MissingItemBlunder(this);
        });
        class_1799 glass = ctx.getStack(this, slot2, stack -> stack.method_31574(class_1802.field_8280)).orElseThrow(() -> new MissingItemBlunder(this));
        class_1792 sourceItem = sourceSlot.getItem(this, ctx);
        KnotItem type = this.types.get(sourceItem);
        if (type == null) {
            throw new ItemInvalidBlunder(this);
        }
        try {
            class_1799 input = sourceSlot.move(this, ctx, 1);
            try {
                ctx.useMana(this, type.getCreationCost());
                ctx.source().offerOrDropItem(type.createStack((class_1937)ctx.source().getWorld()));
                ctx.source().getPlayer().ifPresent(player -> ModCriteria.CREATE_KNOT.trigger((class_3222)player, type));
                return VoidFragment.INSTANCE;
            }
            catch (Exception e) {
                ctx.source().offerOrDropItem(input);
                throw e;
            }
        }
        catch (Exception e) {
            ctx.source().offerOrDropItem(glass);
            throw e;
        }
    }

    public void registerKnot(class_1792 input, KnotItem output) {
        KnotItem old = this.types.put(input, output);
        if (old != null) {
            Trickster.LOGGER.warn("Creation of \"{}\" from \"{}\" has been overridden by \"{}\"", new Object[]{old.method_7848().getString(), input.method_7848().getString(), output.method_7848().getString()});
        }
    }
}

