/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.misc;

import dev.enjarai.trickster.cca.MessageHandlerComponent;
import dev.enjarai.trickster.cca.ModGlobalComponents;
import dev.enjarai.trickster.item.ChannelItem;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.ItemInvalidBlunder;
import dev.enjarai.trickster.spell.blunder.OutOfRangeBlunder;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class MessageSendTrick
extends Trick<MessageSendTrick> {
    public static final NumberFragment DEFAULT_RANGE = new NumberFragment(16.0);

    public MessageSendTrick() {
        super(Pattern.of(4, 8, 1, 6, 4), Signature.of(ANY, FragmentType.NUMBER.optionalOf(), MessageSendTrick::broadcast));
        this.overload(Signature.of(ANY, FragmentType.SLOT, MessageSendTrick::channel));
    }

    public Fragment broadcast(SpellContext ctx, Fragment value, Optional<NumberFragment> range) throws BlunderException {
        range.ifPresent(n -> ctx.useMana(this, (float)n.number()));
        return this.run(ctx, new MessageHandlerComponent.Key.Broadcast((class_5321<class_1937>)ctx.source().getWorld().method_27983(), ctx.source().getPos(), range.orElse(DEFAULT_RANGE).number()), value);
    }

    public Fragment channel(SpellContext ctx, Fragment value, SlotFragment slot) throws BlunderException {
        class_1799 stack = slot.reference(this, ctx);
        double range = ctx.source().getPos().distance(slot.getSourcePos(this, ctx));
        class_1792 item = stack.method_7909();
        if (item instanceof ChannelItem) {
            ChannelItem channelItem = (ChannelItem)item;
            if (range > (double)channelItem.getRange()) {
                throw new OutOfRangeBlunder(this, channelItem.getRange(), range);
            }
            channelItem.messageSendBehavior(this, ctx, stack, value);
            return value;
        }
        throw new ItemInvalidBlunder(this);
    }

    public Fragment run(SpellContext ctx, MessageHandlerComponent.Key key, Fragment value) throws BlunderException {
        ((MessageHandlerComponent)ModGlobalComponents.MESSAGE_HANDLER.get((Object)ctx.source().getWorld().method_14170())).send(key, value);
        return value;
    }
}

