/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.trick.tree;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.tree.AbstractMetaTrick;
import dev.enjarai.trickster.spell.type.Signature;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oshi.util.tuples.Pair;

public class LocateGlyphTrick
extends AbstractMetaTrick<LocateGlyphTrick> {
    public LocateGlyphTrick() {
        super(Pattern.of(6, 7, 8, 2, 1, 0, 4, 8, 5), Signature.of(FragmentType.SPELL_PART, ANY, LocateGlyphTrick::locate));
    }

    public Fragment locate(SpellContext ctx, SpellPart spell, Fragment glyph) throws BlunderException {
        List<Integer> address = this.search(spell, glyph);
        if (address == null) {
            return VoidFragment.INSTANCE;
        }
        return new ListFragment(address.stream().map(num -> new NumberFragment(num.intValue())).toList());
    }

    private List<Integer> search(SpellPart spell, Fragment target) {
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(new Pair((Object)new Integer[0], (Object)spell));
        while (!queue.isEmpty()) {
            Pair temp = (Pair)queue.poll();
            if (((SpellPart)temp.getB()).glyph.equals(target)) {
                return Arrays.asList((Integer[])temp.getA());
            }
            List<SpellPart> subParts = ((SpellPart)temp.getB()).subParts;
            for (int i = 0; i < subParts.size(); ++i) {
                Integer[] newAddress = Arrays.copyOfRange((Integer[])temp.getA(), 0, ((Integer[])temp.getA()).length + 1);
                newAddress[((Integer[])temp.getA()).length] = i;
                queue.add(new Pair((Object)newAddress, (Object)subParts.get(i)));
            }
        }
        return null;
    }
}

